/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.entitylistener;

import com.sun.ts.tests.jpa.core.override.entitylistener.ListenerA;
import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@EntityListeners(value={ListenerA.class})
@Table(name="NOENTITYLISTENER_TABLE")
public class OverridenListener
implements Serializable {
    private Long id;

    @Id
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @PrePersist
    public void prePersist() {
        this.updateCallBackCount("prePersist");
    }

    @PostPersist
    public void postPersist() {
        this.updateCallBackCount("postPersist");
    }

    protected void updateCallBackCount(String callBackKeyName) {
        CallBackCounts.updateCount(callBackKeyName);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OverridenListener)) {
            return false;
        }
        OverridenListener other = (OverridenListener)object;
        return this.id == other.id || this.id != null && this.id.equals(other.id);
    }

    public String toString() {
        return "com.sun.ts.tests.jpa.core.override.entitylistener.OverridenListener id=" + this.id;
    }
}

