/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ1;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;

    public MsgBean() {
        TestUtil.logTrace((String)"@MsgBean()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ1  - @MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            if (this.queue == null) {
                TestUtil.logTrace((String)"queue error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgTypesQ1 @onMessage!" + msg));
        try {
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("bytesMsgNullStreamQTest")) {
                this.bytesMsgNullStreamQTest();
            } else if (msg.getStringProperty("TestCase").equals("bytesMessageQTestsFullMsgCreate")) {
                TestUtil.logTrace((String)"@onMessage - running bytesMessageQTestsFullMsg1 - create the message");
                this.bytesMessageQTestsFullMsgCreate();
            } else if (msg.getStringProperty("TestCase").equals("bytesMessageQTestsFullMsg")) {
                TestUtil.logTrace((String)"@onMessage - running bytesMessageQTestsFullMsg - read and verify the message");
                this.bytesMessageQTestsFullMsg((BytesMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageFullMsgQTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageFullMsgQTestCreate - read and verify the message");
                this.mapMessageFullMsgQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageFullMsgQTest")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageFullMsgQTest - read and verify the message");
                this.mapMessageFullMsgQTest((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBooleanCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsBooleanCreate - read and verify the message");
                this.mapMessageConversionQTestsBooleanCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBoolean")) {
                TestUtil.logTrace((String)"@onMessage - running MapMessageConversionQTestsBoolean - read and verify the message");
                this.mapMessageConversionQTestsBoolean((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsByteCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsByteCreate - read and verify the message");
                this.mapMessageConversionQTestsByteCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsByte")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsByte - read and verify the message");
                this.mapMessageConversionQTestsByte((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsShortCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsShortCreate - read and verify the message");
                this.mapMessageConversionQTestsShortCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsShort")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsShort - read and verify the message");
                this.mapMessageConversionQTestsShort((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsCharCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsCharCreate - read and verify the message");
                this.mapMessageConversionQTestsCharCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsChar")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsChar - read and verify the message");
                this.mapMessageConversionQTestsChar((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsIntCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsIntCreate - read and verify the message");
                this.mapMessageConversionQTestsIntCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsInt")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsInt - read and verify the message");
                this.mapMessageConversionQTestsInt((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsLongCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsLongCreate - read and verify the message");
                this.mapMessageConversionQTestsLongCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsLong")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsLong - read and verify the message");
                this.mapMessageConversionQTestsLong((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsFloatCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsFloatCreate - read and verify the message");
                this.mapMessageConversionQTestsFloatCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsFloat")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsFloat - read and verify the message");
                this.mapMessageConversionQTestsFloat((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsDoubleCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsDoubleCreate - read and verify the message");
                this.mapMessageConversionQTestsDoubleCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsDouble")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsDouble - read and verify the message");
                this.mapMessageConversionQTestsDouble((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsStringCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsStringCreate - read and verify the message");
                this.mapMessageConversionQTestsStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsString")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsString - read and verify the message");
                this.mapMessageConversionQTestsString((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBytesCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsBytesCreate - read and verify the message");
                this.mapMessageConversionQTestsBytesCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsBytes")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsBytes - read and verify the message");
                this.mapMessageConversionQTestsBytes((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsInvFormatStringCreate")) {
                TestUtil.logTrace((String)"@onMessage - running mapMessageConversionQTestsInvFormatStringCreate - read and verify the message");
                this.mapMessageConversionQTestsInvFormatStringCreate();
            } else if (msg.getStringProperty("TestCase").equals("mapMessageConversionQTestsInvFormatString")) {
                TestUtil.logTrace((String)"@onMessage - running  mapMessageConversionQTestsInvFormatString - read and verify the message");
                this.mapMessageConversionQTestsInvFormatString((MapMessage)msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
                TestUtil.logTrace((String)("@onMessage - could not find method for this testcase: " + msg.getStringProperty("TestCase")));
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void bytesMsgNullStreamQTest() {
        BytesMessage messageSentBytesMessage = null;
        boolean ok = true;
        TextMessage msg = null;
        TestUtil.logTrace((String)"@bytesMsgNullStreamQTest");
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, this.p);
            msg.setStringProperty("TestCase", "bytesMsgNullStreamQTest");
            msg.setText("bytesMsgNullStreamQTest");
            TestUtil.logTrace((String)"Writing a null stream to byte message should throw a NullPointerException");
            messageSentBytesMessage = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, this.p);
            messageSentBytesMessage.writeObject(null);
            TestUtil.logTrace((String)"Fail: message did not throw NullPointerException exception as expected");
        }
        catch (NullPointerException np) {
            TestUtil.logTrace((String)"Pass: NullPointerException thrown as expected");
            ok = true;
        }
        catch (JMSException jmsE) {
            TestUtil.printStackTrace((Throwable)jmsE);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)jmsE)).getClass().getName() + " was thrown"));
            ok = false;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            ok = false;
        }
        try {
            if (ok) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    private void bytesMessageQTestsFullMsgCreate() {
        this.mSender = null;
        TestUtil.logTrace((String)"MsgBean - @bytesMessageQTestsFullMsgCreate");
        try {
            BytesMessage messageSent = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMessageQTestsFullMsg");
            TestUtil.logTrace((String)"Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            messageSent.setStringProperty("TestCase", "bytesMessageQTestsFullMsg");
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void bytesMessageQTestsFullMsg(BytesMessage msg) {
        TestUtil.logTrace((String)"MsgBean - @bytesMessageQTestsFullMsg");
        String testCase = "bytesMessageQTestsFullMsg";
        try {
            Object messageSent = null;
            BytesMessage messageReceived = msg;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            TestUtil.logTrace((String)"Starting tests in @bytesMessageQTestsFullMsg");
            try {
                if (messageReceived.readBoolean() == booleanValue) {
                    TestUtil.logTrace((String)"Pass: boolean returned ok");
                } else {
                    TestUtil.logTrace((String)"Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readByte() == byteValue) {
                    TestUtil.logTrace((String)"Pass: Byte returned ok");
                } else {
                    TestUtil.logTrace((String)"Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    TestUtil.logTrace((String)"Pass: correct char");
                } else {
                    TestUtil.logTrace((String)"Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == doubleValue) {
                    TestUtil.logTrace((String)"Pass: correct double");
                } else {
                    TestUtil.logTrace((String)"Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == floatValue) {
                    TestUtil.logTrace((String)"Pass: correct float");
                } else {
                    TestUtil.logTrace((String)"Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readInt() == intValue) {
                    TestUtil.logTrace((String)"Pass: correct int");
                } else {
                    TestUtil.logTrace((String)"Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readLong() == longValue) {
                    TestUtil.logTrace((String)"Pass: correct long");
                } else {
                    TestUtil.logTrace((String)"Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readInt() == nInteger.intValue()) {
                    TestUtil.logTrace((String)"Pass: correct Integer returned");
                } else {
                    TestUtil.logTrace((String)"Fail: Integer not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readShort() == shortValue) {
                    TestUtil.logTrace((String)"Pass: correct short");
                } else {
                    TestUtil.logTrace((String)"Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                if (messageReceived.readUTF().equals(utfValue)) {
                    TestUtil.logTrace((String)"Pass: correct UTF");
                } else {
                    TestUtil.logTrace((String)"Fail: UTF not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                for (int i = 0; i < nCount; ++i) {
                    if (bytesValueRecvd[i] != bytesValue[i]) {
                        TestUtil.logTrace((String)"Fail: bytes value incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Pass: byte value " + i + " ok"));
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                TestUtil.logTrace((String)("count returned " + nCount));
                if (bytesValueRecvd[0] != bytesValue[0]) {
                    TestUtil.logTrace((String)"Fail: bytes value incorrect");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: byte value ok");
                }
                if (nCount == 1) {
                    TestUtil.logTrace((String)"Pass: correct count");
                } else {
                    TestUtil.logTrace((String)"Fail: count not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageFullMsgQTestCreate() {
        boolean booleanValue = false;
        byte byteValue = 127;
        byte[] bytesValue = new byte[]{127, -127, 1, 0};
        char charValue = 'Z';
        double doubleValue = 6.02E23;
        float floatValue = 6.02E23f;
        int intValue = Integer.MAX_VALUE;
        long longValue = Long.MAX_VALUE;
        short shortValue = Short.MAX_VALUE;
        String stringValue = "Map Message Test";
        Integer integerValue = 100;
        String initial = "spring is here!";
        try {
            MapMessage messageSentMapMessage = null;
            TestUtil.logTrace((String)"Send MapMessage to Topic.");
            messageSentMapMessage = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSentMapMessage, this.p);
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageFullMsgQTestCreate");
            messageSentMapMessage.setBoolean("booleanValue", booleanValue);
            messageSentMapMessage.setByte("byteValue", byteValue);
            messageSentMapMessage.setBytes("bytesValue", bytesValue);
            messageSentMapMessage.setBytes("bytesValue2", bytesValue, 0, 1);
            messageSentMapMessage.setChar("charValue", charValue);
            messageSentMapMessage.setDouble("doubleValue", doubleValue);
            messageSentMapMessage.setFloat("floatValue", floatValue);
            messageSentMapMessage.setInt("intValue", intValue);
            messageSentMapMessage.setLong("longValue", longValue);
            messageSentMapMessage.setObject("integerValue", (Object)integerValue);
            messageSentMapMessage.setShort("shortValue", shortValue);
            messageSentMapMessage.setString("stringValue", stringValue);
            messageSentMapMessage.setString("nullTest", null);
            messageSentMapMessage.setStringProperty("TestCase", "mapMessageFullMsgQTest");
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageFullMsgQTest(MapMessage messageReceivedMapMessage) {
        String testCase = "mapMessageFullMsgQTest";
        boolean pass = true;
        boolean booleanValue = false;
        byte byteValue = 127;
        byte[] bytesValue = new byte[]{127, -127, 1, 0};
        char charValue = 'Z';
        double doubleValue = 6.02E23;
        float floatValue = 6.02E23f;
        int intValue = Integer.MAX_VALUE;
        long longValue = Long.MAX_VALUE;
        short shortValue = Short.MAX_VALUE;
        String stringValue = "Map Message Test";
        Integer integerValue = 100;
        String initial = "spring is here!";
        try {
            byte[] b;
            try {
                if (messageReceivedMapMessage.getBoolean("booleanValue") == booleanValue) {
                    TestUtil.logTrace((String)"Pass: valid boolean returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid boolean returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getByte("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: valid byte returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid byte returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                b = messageReceivedMapMessage.getBytes("bytesValue");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != bytesValue[i]) {
                        TestUtil.logTrace((String)("Fail: byte array " + i + " not valid"));
                        pass = false;
                        continue;
                    }
                    TestUtil.logTrace((String)("Pass: byte array " + i + " valid"));
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                b = messageReceivedMapMessage.getBytes("bytesValue2");
                if (b[0] != bytesValue[0]) {
                    TestUtil.logTrace((String)"Fail: byte array not valid");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: byte array valid");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getChar("charValue") == charValue) {
                    TestUtil.logTrace((String)"Pass: valid char returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid char returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getDouble("doubleValue") == doubleValue) {
                    TestUtil.logTrace((String)"Pass: valid double returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid double returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getFloat("floatValue") == floatValue) {
                    TestUtil.logTrace((String)"Pass: valid float returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid float returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getInt("intValue") == intValue) {
                    TestUtil.logTrace((String)"Pass: valid int returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid int returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getLong("longValue") == longValue) {
                    TestUtil.logTrace((String)"Pass: valid long returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid long returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getObject("integerValue").toString().equals(integerValue.toString())) {
                    TestUtil.logTrace((String)"Pass: valid object returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid object returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getShort("shortValue") == shortValue) {
                    TestUtil.logTrace((String)"Pass: valid short returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid short returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getString("stringValue").equals(stringValue)) {
                    TestUtil.logTrace((String)"Pass: valid string returned");
                } else {
                    TestUtil.logTrace((String)"Fail: invalid string returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            try {
                if (messageReceivedMapMessage.getString("nullTest") == null) {
                    TestUtil.logTrace((String)"Pass: null returned");
                } else {
                    TestUtil.logTrace((String)"Fail:  null not returned from getString");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Fail: unexpected exception " + e.getClass().getName() + " was returned"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBooleanCreate() {
        try {
            MapMessage messageSent = null;
            Object messageReceived = null;
            boolean booleanValue = true;
            boolean pass = true;
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsBooleanCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsBoolean");
            TestUtil.logTrace((String)"Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.setBoolean("booleanValue", booleanValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBoolean(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsBoolean";
        try {
            boolean booleanValue = true;
            boolean pass = true;
            TestUtil.logTrace((String)"Verify conversion support for boolean primitive type section 3.11.3");
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBoolean to read a boolean");
            try {
                if (messageReceived.getBoolean("booleanValue") == booleanValue) {
                    TestUtil.logTrace((String)"Pass: boolean to boolean - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readString to read a boolean");
            try {
                if (messageReceived.getString("booleanValue").equals(Boolean.valueOf(booleanValue).toString())) {
                    TestUtil.logTrace((String)"Pass: boolean to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                byte[] b = messageReceived.getBytes("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)("Count returned from readBytes is : " + nCount));
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readByte to read a boolean - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readShort to read a boolean - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readChar to read a boolean - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readInt to read a boolean - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readLong to read a boolean - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readFloat to read a boolean - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use readDouble to read a boolean - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("booleanValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsByteCreate() {
        MapMessage messageSent = null;
        byte byteValue = 127;
        boolean pass = true;
        try {
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsByteCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsByte");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setByte("byteValue", byteValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsByte(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsByte";
        Object messageSent = null;
        byte byteValue = 127;
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a byte - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("byteValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a byte");
            try {
                if (messageReceived.getString("byteValue").equals(Byte.toString(byteValue))) {
                    TestUtil.logTrace((String)"Pass: byte to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read a byte - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("byteValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a byte");
            try {
                if (messageReceived.getByte("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to byte - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a byte");
            try {
                if (messageReceived.getShort("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to short - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a boolean - this is not valid");
            try {
                char c = messageReceived.getChar("byteValue");
                pass = false;
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a byte");
            try {
                if (messageReceived.getInt("byteValue") == byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a byte");
            try {
                if (messageReceived.getLong("byteValue") == (long)byteValue) {
                    TestUtil.logTrace((String)"Pass: byte to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a boolean - this is not valid");
            try {
                float f = messageReceived.getFloat("byteValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a boolean - this is not valid");
            try {
                double d = messageReceived.getDouble("byteValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void mapMessageConversionQTestsShortCreate() {
        try {
            MapMessage messageSent = null;
            short shortValue = 1;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "MapMessageConversionQTestsShort");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsShort");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setShort("shortValue", shortValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsShort(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsShort";
        try {
            short shortValue = 1;
            boolean pass = true;
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a short - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("shortValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a short");
            try {
                if (messageReceived.getString("shortValue").equals(Short.toString(shortValue))) {
                    TestUtil.logTrace((String)"Pass: short to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read a short - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("shortValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a short - this is not valid");
            try {
                byte b = messageReceived.getByte("shortValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a short");
            try {
                if (messageReceived.getShort("shortValue") == shortValue) {
                    TestUtil.logTrace((String)"Pass: short to short - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a short - this is not valid");
            try {
                char c = messageReceived.getChar("shortValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a short");
            try {
                if (messageReceived.getInt("shortValue") == shortValue) {
                    TestUtil.logTrace((String)"Pass: short to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a short");
            try {
                if (messageReceived.getLong("shortValue") == (long)shortValue) {
                    TestUtil.logTrace((String)"Pass: short to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a short - this is not valid");
            try {
                float f = messageReceived.getFloat("shortValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a short - this is not valid");
            try {
                double d = messageReceived.getDouble("shortValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsCharCreate() {
        try {
            MapMessage messageSent = null;
            char charValue = 'a';
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsChar");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsChar");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setChar("charValue", charValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsIntCreate() {
        try {
            MapMessage messageSent = null;
            int intValue = 6;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsIntCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsInt");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setInt("intValue", intValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsLongCreate() {
        try {
            MapMessage messageSent = null;
            long longValue = 2L;
            boolean pass = true;
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsLongCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsLong");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setLong("longValue", longValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsFloatCreate() {
        try {
            MapMessage messageSent = null;
            float floatValue = 5.0f;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsFloatCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsFloat");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setFloat("floatValue", floatValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsDoubleCreate() {
        try {
            MapMessage messageSent = null;
            double doubleValue = 3.0;
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsDoubleCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsDouble");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setDouble("doubleValue", doubleValue);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsStringCreate() {
        try {
            MapMessage messageSent = null;
            boolean pass = true;
            String myString = "10";
            String myString2 = "true";
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsStringCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            messageSent.setString("myString2", myString2);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBytesCreate() {
        try {
            MapMessage messageSent = null;
            byte[] byteValues = new byte[]{1, 2, 3};
            boolean pass = true;
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsBytesCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsBytes");
            TestUtil.logTrace((String)"Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.setBytes("byteValues", byteValues);
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsInvFormatStringCreate() {
        try {
            MapMessage messageSent = null;
            boolean pass = true;
            String myString = "mytest string";
            messageSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "mapMessageConversionQTestsInvFormatStringCreate");
            messageSent.setStringProperty("TestCase", "mapMessageConversionQTestsInvFormatString");
            TestUtil.logTrace((String)"Verify conversion support for byte primitive type section 3.11.3");
            messageSent.setString("myString", myString);
            TestUtil.logTrace((String)"Sending message");
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsChar(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsChar";
        try {
            char charValue = 'a';
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a char - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a char");
            try {
                if (messageReceived.getString("charValue").equals(Character.valueOf(charValue).toString())) {
                    TestUtil.logTrace((String)"Pass: char to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read a char - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a char - this is not valid");
            try {
                byte b = messageReceived.getByte("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a char");
            try {
                short s = messageReceived.getShort("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a char ");
            try {
                if (messageReceived.getChar("charValue") == charValue) {
                    TestUtil.logTrace((String)"Pass: char to char - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a char ");
            try {
                int i = messageReceived.getInt("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a char");
            try {
                long l = messageReceived.getLong("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a char - this is not valid");
            try {
                float f = messageReceived.getFloat("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a char - this is not valid");
            try {
                double d = messageReceived.getDouble("charValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsInt(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsInt";
        try {
            int intValue = 6;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read an int - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read an int");
            try {
                if (messageReceived.getString("intValue").equals(Integer.toString(intValue))) {
                    TestUtil.logTrace((String)"Pass: int to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read an int - expect MessageFormatException");
            boolean nCount = false;
            try {
                byte[] b = messageReceived.getBytes("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read an int - this is not valid");
            try {
                byte b = messageReceived.getByte("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read an int");
            try {
                short s = messageReceived.getShort("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read an int - this is not valid");
            try {
                char c = messageReceived.getChar("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read an int");
            try {
                if (messageReceived.getInt("intValue") == intValue) {
                    TestUtil.logTrace((String)"Pass: int to int - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read an int");
            try {
                if (messageReceived.getLong("intValue") == (long)intValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read an int - this is not valid");
            try {
                float f = messageReceived.getFloat("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read an int - this is not valid");
            try {
                double d = messageReceived.getDouble("intValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsLong(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsLong";
        try {
            long longValue = 2L;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a long - this is not valid");
            try {
                boolean b = messageReceived.getBoolean("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a long");
            try {
                if (messageReceived.getString("longValue").equals(Long.toString(longValue))) {
                    TestUtil.logTrace((String)"Pass: long to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read  a long - expect MessageFormatException");
            try {
                byte[] b = messageReceived.getBytes("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read an long - this is not valid");
            try {
                byte b = messageReceived.getByte("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a long");
            try {
                short s = messageReceived.getShort("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a long - this is not valid");
            try {
                char c = messageReceived.getChar("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a long");
            try {
                int i = messageReceived.getInt("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a long");
            try {
                if (messageReceived.getLong("longValue") == longValue) {
                    TestUtil.logTrace((String)"Pass: int to long - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a long - this is not valid");
            try {
                float f = messageReceived.getFloat("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a long ");
            try {
                double d = messageReceived.getDouble("longValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsFloat(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsFloat";
        try {
            float floatValue = 5.0f;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a float  ");
            try {
                boolean b = messageReceived.getBoolean("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a float");
            try {
                if (messageReceived.getString("floatValue").equals(Float.toString(floatValue))) {
                    TestUtil.logTrace((String)"Pass: float to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read  a float ");
            try {
                byte[] b = messageReceived.getBytes("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a float  ");
            try {
                byte b = messageReceived.getByte("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a float");
            try {
                short s = messageReceived.getShort("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a long  ");
            try {
                char c = messageReceived.getChar("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a float");
            try {
                int i = messageReceived.getInt("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a long");
            try {
                long l = messageReceived.getLong("floatValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a float  ");
            try {
                if (messageReceived.getFloat("floatValue") == floatValue) {
                    TestUtil.logTrace((String)"Pass: float to float - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a float  ");
            try {
                if (messageReceived.getDouble("floatValue") == (double)floatValue) {
                    TestUtil.logTrace((String)"Pass: float to double - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsDouble(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsDouble";
        try {
            double doubleValue = 3.0;
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a double  ");
            try {
                boolean b = messageReceived.getBoolean("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a double");
            try {
                if (messageReceived.getString("doubleValue").equals(Double.toString(doubleValue))) {
                    TestUtil.logTrace((String)"Pass: double to string");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read  a double ");
            try {
                byte[] b = messageReceived.getBytes("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a double  ");
            try {
                byte b = messageReceived.getByte("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a double");
            try {
                short s = messageReceived.getShort("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a double  ");
            try {
                char c = messageReceived.getChar("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a double");
            try {
                int i = messageReceived.getInt("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a double");
            try {
                long l = messageReceived.getLong("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a double  ");
            try {
                float f = messageReceived.getFloat("doubleValue");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read an float  ");
            try {
                if (messageReceived.getDouble("doubleValue") == doubleValue) {
                    TestUtil.logTrace((String)"Pass: double to double ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsString(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsString";
        try {
            boolean pass = true;
            String myString = "10";
            String myString2 = "true";
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a String");
            try {
                if (messageReceived.getString("myString").equals(myString)) {
                    TestUtil.logTrace((String)"Pass: string to string - valid");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read a String");
            try {
                byte[] b = messageReceived.getBytes("myString");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a String");
            try {
                if (messageReceived.getByte("myString") == Byte.parseByte(myString)) {
                    TestUtil.logTrace((String)"Pass: String to byte ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a string");
            try {
                if (messageReceived.getShort("myString") == Short.parseShort(myString)) {
                    TestUtil.logTrace((String)"Pass: String to short ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a String ");
            try {
                char c = messageReceived.getChar("myString");
                TestUtil.logTrace((String)("getChar returned " + c));
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a String");
            try {
                if (messageReceived.getInt("myString") == Integer.parseInt(myString)) {
                    TestUtil.logTrace((String)"Pass: String to int ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a String");
            try {
                if (messageReceived.getLong("myString") == Long.parseLong(myString)) {
                    TestUtil.logTrace((String)"Pass: String to long ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a String");
            try {
                if (messageReceived.getFloat("myString") == Float.parseFloat(myString)) {
                    TestUtil.logTrace((String)"Pass: String to float ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a String");
            try {
                if (messageReceived.getDouble("myString") == Double.parseDouble(myString)) {
                    TestUtil.logTrace((String)"Pass: String to double ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a string ");
            try {
                if (messageReceived.getBoolean("myString2") == Boolean.valueOf(myString2).booleanValue()) {
                    TestUtil.logTrace((String)"Pass: String to boolean ");
                } else {
                    TestUtil.logTrace((String)"Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: unexpected exception" + e.getClass().getName() + "was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a string that is not true");
            try {
                boolean b = messageReceived.getBoolean("myString");
                if (b) {
                    TestUtil.logTrace((String)"Fail: !true should have returned false");
                    pass = false;
                } else {
                    TestUtil.logTrace((String)"Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsBytes(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsBytes";
        try {
            byte[] byteValues = new byte[]{1, 2, 3};
            boolean pass = true;
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBytes[] to read a byte[] ");
            try {
                byte[] b = messageReceived.getBytes("byteValues");
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] != byteValues[i]) {
                        TestUtil.logTrace((String)"Fail: byte[] value returned is invalid");
                        pass = false;
                        continue;
                    }
                    TestUtil.logTrace((String)"Pass: byte[] returned is valid");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getBoolean to read a byte[]");
            try {
                boolean b = messageReceived.getBoolean("byteValues");
                TestUtil.logTrace((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getString to read a byte[]");
            try {
                String s = messageReceived.getString("byteValues");
                TestUtil.logTrace((String)"Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a byte[] - expect MessageFormatException");
            try {
                byte b = messageReceived.getByte("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a byte[] - expect MessageFormatException");
            try {
                short s = messageReceived.getShort("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getChar to read a byte[] - expect MessageFormatException");
            try {
                char c = messageReceived.getChar("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a byte[] - expect MessageFormatException");
            try {
                int i = messageReceived.getInt("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a byte[] - expect MessageFormatException");
            try {
                long l = messageReceived.getLong("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a byte[] - expect MessageFormatException");
            try {
                float f = messageReceived.getFloat("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a byte[] - expect MessageFormatException");
            try {
                double d = messageReceived.getDouble("byteValues");
                TestUtil.logTrace((String)"Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (MessageFormatException mf) {
                TestUtil.logTrace((String)"Pass: MessageFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void mapMessageConversionQTestsInvFormatString(MapMessage messageReceived) {
        String testCase = "mapMessageConversionQTestsInvFormatString";
        try {
            boolean pass = true;
            String myString = "mytest string";
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getByte to read a String that is not valid ");
            try {
                byte b = messageReceived.getByte("myString");
                TestUtil.logTrace((String)"Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getShort to read a string that is not valid ");
            try {
                short s = messageReceived.getShort("myString");
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getInt to read a String that is not valid ");
            try {
                int i = messageReceived.getInt("myString");
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getLong to read a String that is not valid ");
            try {
                long l = messageReceived.getLong("myString");
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getFloat to read a String that is not valid ");
            try {
                float f = messageReceived.getFloat("myString");
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            TestUtil.logTrace((String)"--");
            TestUtil.logTrace((String)"Use getDouble to read a String that is not valid ");
            try {
                double d = messageReceived.getDouble("myString");
                TestUtil.logTrace((String)"Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (NumberFormatException nf) {
                TestUtil.logTrace((String)"Pass: NumberFormatException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            this.sendTestResults(testCase, pass);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            TestUtil.logTrace((String)("==================================Test Results from: " + testCase));
            TestUtil.logTrace((String)("==================================Status: " + results));
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ1  In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ1  In MsgBean::remove()!!");
    }
}

