/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.exceptions;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Product;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import jakarta.ejb.FinderException;
import jakarta.ejb.ObjectNotFoundException;
import java.util.Collection;
import java.util.Properties;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.props = p;
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void exceptionTest1() throws EETest.Fault {
        boolean pass = true;
        Product p = null;
        try {
            TestUtil.logMsg((String)"Find products with name: Sparcstation 5");
            p = this.productHome.findProductByName("Sparcstation 5");
            TestUtil.logErr((String)"Exception not thrown as expected");
            pass = false;
        }
        catch (ObjectNotFoundException e) {
            TestUtil.logMsg((String)("Caught ObjectNotFoundException as expected: " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception exceptionTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("exceptionTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest1 failed");
        }
    }

    public void exceptionTest2() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Find all products by quantity");
            p = this.productHome.findAllProductsByQuantity();
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully handled a collection return of 0");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned a collection of 0");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception exceptionTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("exceptionTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest2 failed");
        }
    }

    public void exceptionTest3() throws EETest.Fault {
        boolean pass = true;
        Product p = null;
        try {
            TestUtil.logMsg((String)"Find product by Name: Ultra Sparc 10");
            p = this.productHome.selectProductByName("Ultra Sparc 10");
            TestUtil.logErr((String)"Exception not thrown as expected");
            pass = false;
        }
        catch (ObjectNotFoundException e) {
            TestUtil.logMsg((String)("Caught ObjectNotFoundException as expected: " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception exceptionTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("exceptionTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest3 failed");
        }
    }

    public void exceptionTest4() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Find all products by name");
            p = this.productHome.selectAllProducts();
            expectedPKs = new String[]{};
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully handled a collection return of 0");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned a collection of 0");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception exceptionTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("exceptionTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest4 failed");
        }
    }

    public void exceptionTest5() throws EETest.Fault {
        boolean pass = true;
        Product p = null;
        try {
            TestUtil.logMsg((String)"Find PC products");
            p = this.productHome.selectProductByType();
            TestUtil.logErr((String)"Exception not thrown as expected");
            pass = false;
        }
        catch (FinderException e) {
            TestUtil.logMsg((String)("Caught FinderException as expected: " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception exceptionTest5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("exceptionTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest5 failed");
        }
    }

    public void exceptionTest6() throws EETest.Fault {
        boolean pass = true;
        Product p = null;
        try {
            TestUtil.logMsg((String)"Find Programming products");
            p = this.productHome.findProductByName("Java_2%Programming");
            TestUtil.logErr((String)"Exception not thrown as expected");
            pass = false;
        }
        catch (FinderException e) {
            TestUtil.logMsg((String)"Caught FinderException as expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception exceptionTest6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("exceptionTest6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("exceptionTest6 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

