/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.query.parameter;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.query.parameter.Employee;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    protected final Employee[] empRef = new Employee[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployee(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupEmployee");
        try {
            super.setup(args, p);
            this.createEmployeeData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void parameterTest1() throws EETest.Fault {
        String sExpected;
        Parameter p1;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        boolean pass8 = false;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last");
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                TestUtil.logTrace((String)("Parameter position = " + p.getPosition()));
                TestUtil.logTrace((String)("Parameter type =" + p.getParameterType()));
            }
        }
        if (query.isBound(p1 = query.getParameter(sExpected = "first"))) {
            TestUtil.logErr((String)("isBound believes there is a value bound to the parameter:" + sExpected));
        } else {
            pass1 = true;
        }
        String sActual = p1.getName();
        if (!sActual.equals(sExpected)) {
            TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
        } else {
            pass2 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
        } else {
            pass3 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass4 = true;
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logMsg((String)"warning: p1.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        sExpected = "last";
        Parameter p2 = query.getParameter(sExpected);
        if (query.isBound(p2)) {
            TestUtil.logErr((String)("isBound believes there is a value bound to the parameter:" + sExpected));
        } else {
            pass5 = true;
        }
        sActual = p2.getName();
        if (!sActual.equals(sExpected)) {
            TestUtil.logErr((String)("p2.getName() - Expected: " + sExpected + ", actual:" + sActual));
        } else {
            pass6 = true;
        }
        sExpected = null;
        iActual = p2.getPosition();
        if (iActual != null) {
            TestUtil.logErr((String)("p2.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
        } else {
            pass7 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p2.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p2.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass8 = true;
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logMsg((String)"warning: p2.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new EETest.Fault("parameterTest1 failed");
        }
    }

    public void parameterTestTQ1() throws EETest.Fault {
        String sExpected;
        Parameter p1;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        boolean pass8 = false;
        TypedQuery query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last", Employee.class);
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                TestUtil.logTrace((String)("Parameter position = " + p.getPosition()));
                TestUtil.logTrace((String)("Parameter type =" + p.getParameterType()));
            }
        }
        if (query.isBound(p1 = query.getParameter(sExpected = "first"))) {
            TestUtil.logErr((String)("isBound believes there is a value bound to the parameter:" + sExpected));
        } else {
            pass1 = true;
        }
        String sActual = p1.getName();
        if (!sActual.equals(sExpected)) {
            TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
        } else {
            pass2 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
        } else {
            pass3 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass4 = true;
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logMsg((String)"warning: p1.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        sExpected = "last";
        Parameter p2 = query.getParameter(sExpected);
        if (query.isBound(p2)) {
            TestUtil.logErr((String)("isBound believes there is a value bound to the parameter:" + sExpected));
        } else {
            pass5 = true;
        }
        sActual = p2.getName();
        if (!sActual.equals(sExpected)) {
            TestUtil.logErr((String)("p2.getName() - Expected: " + sExpected + ", actual:" + sActual));
        } else {
            pass6 = true;
        }
        sExpected = null;
        iActual = p2.getPosition();
        if (iActual != null) {
            TestUtil.logErr((String)("p2.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
        } else {
            pass7 = true;
        }
        try {
            sExpected = "java.lang.String";
            sActual = p2.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                TestUtil.logErr((String)("p2.getParameterType() - Expected: " + sExpected + ", actual:" + sActual));
            } else {
                pass8 = true;
            }
        }
        catch (IllegalStateException ise) {
            TestUtil.logMsg((String)"warning: p2.getParameterType() threw IllegalStateException, this is not considered a failure");
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new EETest.Fault("parameterTestTQ1 failed");
        }
    }

    public void parameterTest2() throws EETest.Fault {
        int pass1 = 0;
        int pass2 = 0;
        int pass3 = 0;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = ?1 or e.lastName = ?2");
        Set sParameters = query.getParameters();
        if (sParameters.size() == 2) {
            for (Parameter p : sParameters) {
                if (TestUtil.traceflag) {
                    TestUtil.logTrace((String)("parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("parameter type =" + p.getParameterType()));
                }
                if (query.isBound(p)) {
                    TestUtil.logErr((String)("isBound believes there is a value bound to the parameter:" + p));
                } else {
                    TestUtil.logTrace((String)("query isBound = " + query.isBound(p)));
                    ++pass1;
                }
                Integer pos = p.getPosition();
                if (pos != null) {
                    if (pos == 1 || pos == 2) {
                        String sActual = p.getName();
                        if (sActual != null) {
                            TestUtil.logErr((String)("getName() - Expected: null, actual:" + sActual));
                        } else {
                            ++pass2;
                        }
                        try {
                            String sExpected = "java.lang.String";
                            sActual = p.getParameterType().getName();
                            if (!sActual.equals(sExpected)) {
                                TestUtil.logErr((String)("getParameterType().getName() - Expected: " + sExpected + ", actual:" + sActual));
                                continue;
                            }
                            ++pass3;
                        }
                        catch (IllegalStateException ise) {
                            TestUtil.logMsg((String)"warning: getParameterType().getName() threw IllegalStateException, this is not considered a failure");
                        }
                        continue;
                    }
                    TestUtil.logErr((String)("getPosition() returned an invalid position:" + pos));
                    continue;
                }
                TestUtil.logErr((String)"getPosition() returned null");
            }
        } else {
            TestUtil.logErr((String)("query.getParameters(): Expected: 2 parameters, actual: " + sParameters.size()));
        }
        if (pass1 != 2 || pass2 != 2 || pass3 != 2) {
            throw new EETest.Fault("parameterTest2 failed");
        }
    }

    public void parameterTQTest2() throws EETest.Fault {
        int pass1 = 0;
        int pass2 = 0;
        int pass3 = 0;
        TypedQuery query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = ?1 or e.lastName = ?2", Employee.class);
        Set sParameters = query.getParameters();
        if (sParameters.size() == 2) {
            for (Parameter p : sParameters) {
                if (TestUtil.traceflag) {
                    TestUtil.logTrace((String)("parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("parameter type =" + p.getParameterType()));
                }
                if (query.isBound(p)) {
                    TestUtil.logErr((String)("isBound believes there is a value bound to the parameter:" + p));
                } else {
                    TestUtil.logTrace((String)("query isBound = " + query.isBound(p)));
                    ++pass1;
                }
                Integer pos = p.getPosition();
                if (pos != null) {
                    if (pos == 1 || pos == 2) {
                        String sActual = p.getName();
                        if (sActual != null) {
                            TestUtil.logErr((String)("getName() - Expected: null, actual:" + sActual));
                        } else {
                            ++pass2;
                        }
                        try {
                            String sExpected = "java.lang.String";
                            sActual = p.getParameterType().getName();
                            if (!sActual.equals(sExpected)) {
                                TestUtil.logErr((String)("getParameterType().getName() - Expected: " + sExpected + ", actual:" + sActual));
                                continue;
                            }
                            ++pass3;
                        }
                        catch (IllegalStateException ise) {
                            TestUtil.logMsg((String)"warning: getParameterType().getName() threw IllegalStateException, this is not considered a failure");
                        }
                        continue;
                    }
                    TestUtil.logErr((String)("getPosition() returned an invalid position:" + pos));
                    continue;
                }
                TestUtil.logErr((String)"getPosition() returned null");
            }
        } else {
            TestUtil.logErr((String)("query.getParameters(): Expected: 2 parameters, actual: " + sParameters.size()));
        }
        if (pass1 != 2 || pass2 != 2 || pass3 != 2) {
            throw new EETest.Fault("parameterTQTest2 failed");
        }
    }

    public void parameterTest4() throws EETest.Fault {
        String sExpected;
        Parameter p1;
        String sActual;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.hireDate = :hDate ");
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                TestUtil.logTrace((String)("Parameter position = " + p.getPosition()));
            }
        }
        if (!(sActual = (p1 = query.getParameter(sExpected = "hDate")).getName()).equals(sExpected)) {
            TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
        } else {
            pass1 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
        } else {
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("parameterTest4 failed");
        }
    }

    public void parameterTest5() throws EETest.Fault {
        String sExpected;
        Parameter p1;
        String sActual;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.salary = :salary ");
        if (TestUtil.traceflag) {
            Set sParameters = query.getParameters();
            for (Parameter p : sParameters) {
                TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                TestUtil.logTrace((String)("Parameter position = " + p.getPosition()));
            }
        }
        if (!(sActual = (p1 = query.getParameter(sExpected = "salary")).getName()).equals(sExpected)) {
            TestUtil.logErr((String)("p1.getName() - Expected: " + sExpected + ", actual:" + sActual));
        } else {
            pass1 = true;
        }
        sExpected = null;
        Integer iActual = p1.getPosition();
        if (iActual != null) {
            TestUtil.logErr((String)("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual));
        } else {
            pass2 = true;
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("parameterTest5 failed");
        }
    }

    public void getParametersTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"Starting getParametersTest");
        try {
            Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last");
            if (TestUtil.traceflag) {
                Set sParameters = query.getParameters();
                for (Parameter p : sParameters) {
                    TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("Parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("Parameter type =" + p.getParameterType()));
                }
            }
            boolean foundFirstName = false;
            boolean foundLastName = false;
            int found = 0;
            ArrayList list = new ArrayList(query.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                if (p.getName().equals("first")) {
                    foundFirstName = true;
                    ++found;
                }
                if (!p.getName().equals("last")) continue;
                foundLastName = true;
                ++found;
            }
            if (found == 2 && foundFirstName && foundLastName) {
                pass = true;
            } else {
                if (found != 2) {
                    TestUtil.logErr((String)("Wrong number of parameters returned, expected:2, actual:" + found));
                }
                if (!foundFirstName) {
                    TestUtil.logErr((String)"Parameter 'first' was not returned");
                }
                if (!foundLastName) {
                    TestUtil.logErr((String)"Parameter 'last' was not returned");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getParametersTest failed");
        }
    }

    public void getParametersTQTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"Starting getParametersTest");
        try {
            TypedQuery query = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.firstName = :first or e.lastName = :last", Employee.class);
            if (TestUtil.traceflag) {
                Set sParameters = query.getParameters();
                for (Parameter p : sParameters) {
                    TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("Parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("Parameter type =" + p.getParameterType()));
                }
            }
            boolean foundFirstName = false;
            boolean foundLastName = false;
            int found = 0;
            ArrayList list = new ArrayList(query.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                TestUtil.logTrace((String)("Parameter name = " + p.getName()));
                if (p.getName().equals("first")) {
                    foundFirstName = true;
                    ++found;
                }
                if (!p.getName().equals("last")) continue;
                foundLastName = true;
                ++found;
            }
            if (found == 2 && foundFirstName && foundLastName) {
                pass = true;
            } else {
                if (found != 2) {
                    TestUtil.logErr((String)("Wrong number of parameters returned, expected:2, actual:" + found));
                }
                if (!foundFirstName) {
                    TestUtil.logErr((String)"Parameter 'first' was not returned");
                }
                if (!foundLastName) {
                    TestUtil.logErr((String)"Parameter 'last' was not returned");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getParametersTQTest failed");
        }
    }

    public void getParametersNoParametersTest() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"Starting getParametersTest");
            Query query = this.getEntityManager().createQuery("SELECT e FROM Employee e");
            if (TestUtil.traceflag) {
                Set sParameters = query.getParameters();
                for (Parameter p : sParameters) {
                    TestUtil.logTrace((String)("parameter name = " + p.getName()));
                    TestUtil.logTrace((String)("parameter position = " + p.getPosition()));
                    TestUtil.logTrace((String)("pParameter type =" + p.getParameterType()));
                }
            }
            if (query.getParameters().size() != 0) {
                ArrayList list = new ArrayList(query.getParameters());
                for (int i = 0; i < list.size(); ++i) {
                    Parameter p;
                    p = (Parameter)list.get(i);
                    TestUtil.logErr((String)("parameter name = " + p.getName()));
                }
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getParametersNoParametersTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterPositionalTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT e.id FROM Employee e WHERE e.id > ?2 GROUP BY e.id HAVING e.id <=?1").setParameter(2, (Object)2).setParameter(1, (Object)4).getResultList();
            String[] expectedPKs = new String[]{"3", "4"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Expected 1 result, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("parameterPositionalTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterUpdateTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.firstName=?1, e.lastName=?1 WHERE e.id=1").setParameter(1, (Object)"foo");
            int result_size = q.executeUpdate();
            if (result_size == 1) {
                TestUtil.logTrace((String)"Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp.getFirstName().equals("foo") && emp.getLastName().equals("foo")) {
                TestUtil.logTrace((String)("Received expected result:" + emp.toString()));
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected: firstName=foo, lastName=foo, actual: firstName=" + emp.getFirstName() + ", lastName=" + emp.getLastName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("parameterUpdateTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterCaseTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT e.id FROM Employee e WHERE e.id > :Id GROUP BY e.id HAVING e.id <=:iD").setParameter("Id", (Object)2).setParameter("iD", (Object)4).getResultList();
            String[] expectedPKs = new String[]{"3", "4"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Expected 1 result, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("parameterCaseTest failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void parameterNamedParameterTwiceTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.id >=:ID AND e.id <=:ID");
            List result = q.setParameter("ID", (Object)2).getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Expected 1 result, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("parameterNamedParameterTwiceTest failed");
        }
    }

    public void createEmployeeData() throws Exception {
        TestUtil.logTrace((String)"createDepartmentEmployeeData");
        this.getEntityTransaction().begin();
        try {
            this.empRef[0] = new Employee(1, "Alan", "Frechette");
            this.empRef[1] = new Employee(2, "Arthur", "Frechette");
            this.empRef[2] = new Employee(3, "Shelly", "McGowan");
            this.empRef[3] = new Employee(4, "Robert", "Bissett");
            this.empRef[4] = new Employee(5, "Stephen", "DMilla");
            TestUtil.logTrace((String)"Start to persist employees ");
            for (Employee emp : this.empRef) {
                if (emp == null) continue;
                this.getEntityManager().persist((Object)emp);
                TestUtil.logTrace((String)("persisted employee " + emp.getId()));
            }
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("createDepartmentEmployeeData failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"calling super.cleanup");
        super.cleanup();
    }

    public void cleanupEmployee() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

