/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.implementation.sun.javaee.glassfish;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.implementation.sun.javaee.RuntimeInfo;
import com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.EjbRef;
import com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.SunApplicationClient;
import com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.Ejb;
import com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.SunEjbJar;
import com.sun.ts.lib.implementation.sun.javaee.runtime.web.SunWebApp;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeployment;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.porting.TSDeploymentInterface;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class AutoDeployment
implements TSDeploymentInterface {
    protected static final String DEPLOYED_MODULES_FILE = "ts-deployed-modules";
    protected static String TEMP_DIR;
    protected static String SERVER_LOG;
    private static String newLine;
    protected PrintWriter log;
    protected int iPortingSet = 1;
    private String url = "deployer:???:???:999";
    protected Hashtable htJNDIRefs = null;
    protected Hashtable htDeployedModules = new Hashtable();
    protected PropertyManagerInterface propMgr;
    protected String deployStateFile;
    private String sDepNumber = "1";

    public void init(PrintWriter writer) {
        this.log = writer;
        TestUtil.logHarness((String)"AutoDeployment.init()");
        this.iPortingSet = TSDeployment.iPortingSet;
        TestUtil.logHarness((String)("AutoDeployment:  Using porting set #" + this.iPortingSet));
        try {
            this.propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            String portingString = String.valueOf(this.iPortingSet);
            String portClass = "porting.ts.deploy2.class." + this.iPortingSet;
            TestUtil.logHarness((String)("Using " + portClass));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logHarness((String)"Creation of TSDeployment implementation instance failed. Please check the values of 'porting.ts.deploy2.class.1' and 'porting.ts.deploy2.class.2'");
        }
    }

    private void antSetup(String archive, Project p, String propsNumber) {
        String deployHandlerBuildFile;
        String tsHome = this.propMgr.getProperty("ts.home", "/");
        String pkgNameMinusArchive = archive.substring(archive.indexOf(File.separator + "dist" + File.separator) + 6, archive.lastIndexOf(File.separator));
        if (this.iPortingSet == 1) {
            p.setProperty("deploy.dir", this.propMgr.getProperty("impl.vi.deploy.dir", ""));
            deployHandlerBuildFile = tsHome + File.separator + "bin" + File.separator + "xml" + File.separator + "impl" + File.separator + this.propMgr.getProperty("impl.vi", "glassfish") + File.separator + "deploy.xml";
        } else {
            p.setProperty("deploy.dir", this.propMgr.getProperty("impl.ri.deploy.dir", ""));
            deployHandlerBuildFile = tsHome + File.separator + "bin" + File.separator + "xml" + File.separator + "impl" + File.separator + this.propMgr.getProperty("impl.ri", "glassfish") + File.separator + "deploy.xml";
        }
        TestUtil.logHarnessDebug((String)("antsetup:  deploy.dir = " + p.getProperty("deploy.dir")));
        File buildFile = new File(deployHandlerBuildFile);
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)buildFile);
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)consoleLogger);
    }

    private void antSetupFromInfo(DeploymentInfo info, Project p) {
        String archive = info.getEarFile();
        this.sDepNumber = info.getProperty("deployment.props.number");
        p.setProperty("archive.file", archive);
        this.antSetup(archive, p, this.sDepNumber);
    }

    private void antSetupFromProps(Properties props, Project p) {
        String archive = props.getProperty("ear_file");
        this.sDepNumber = props.getProperty("deployment.props.number");
        p.setProperty("archive.file", archive);
        this.antSetup(archive, p, this.sDepNumber);
    }

    public String deploy(DeploymentInfo info) throws TSDeploymentException {
        Project p = new Project();
        this.antSetupFromInfo(info, p);
        String javaeeLevel = this.propMgr.getProperty("javaee.level", "full");
        if (javaeeLevel.contains("full")) {
            String archiveFile = p.getProperty("archive.file");
            String applicationName = this.getAppNameFromApplicationXML(archiveFile);
            if (applicationName == null) {
                applicationName = archiveFile.substring(archiveFile.lastIndexOf(File.separator) + 1, archiveFile.lastIndexOf("."));
            }
            p.setProperty("deploy.app.name", applicationName);
            p.setProperty("get.stub.clients", "true");
            String sEarFile = info.getEarFile();
            String sTSDeploymentDir = sEarFile.substring(0, sEarFile.lastIndexOf(File.separator) + 1) + "ts_dep";
            p.setProperty("get.stub.clients.ts_dep", sTSDeploymentDir);
        }
        try {
            p.executeTarget("-deploy");
        }
        catch (Throwable t) {
            this.log("Deployment failed for: " + info.getEarFile());
            t.printStackTrace();
            throw new TSDeploymentException(t.getMessage() + System.getProperty("line.separator") + this.getServerLogContents());
        }
        return "";
    }

    public void undeploy(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"AutoDeployment.undeploy()");
        Project pr = new Project();
        this.antSetupFromProps(p, pr);
        try {
            pr.executeTarget("-undeploy");
        }
        catch (Throwable t) {
            this.log("Undeployment failed for: " + p.getProperty("ear_file"));
            t.printStackTrace();
            throw new TSDeploymentException(t.getMessage() + System.getProperty("line.separator") + this.getServerLogContents());
        }
    }

    public boolean isDeployed(Properties p) throws TSDeploymentException {
        this.sDepNumber = p.getProperty("deployment.props.number");
        String sArchive = p.getProperty("ear_file");
        TestUtil.logHarness((String)"AutoDeployment.isDeployed()");
        String archiveNameOnly = sArchive.substring(sArchive.lastIndexOf(File.separator) + 1);
        TestUtil.logHarnessDebug((String)("$$$$$$$$$$$$$ " + archiveNameOnly));
        if (archiveNameOnly.startsWith("vi_built_")) {
            archiveNameOnly = archiveNameOnly.substring(9);
        }
        String autoDeployDir = this.iPortingSet == 1 ? this.propMgr.getProperty("impl.vi.deploy.dir", "UNSET glassfish.deploy.dir") : this.propMgr.getProperty("impl.ri.deploy.dir", "UNSET glassfish.deploy.dir");
        TestUtil.logHarnessDebug((String)("isdeployed:  deploy.dir = " + autoDeployDir));
        if (new File(autoDeployDir + File.separator + archiveNameOnly + "_deployed").exists()) {
            TestUtil.logHarnessDebug((String)"isdeployed:  returning true");
            return true;
        }
        TestUtil.logHarnessDebug((String)"isdeployed:  returning false");
        return false;
    }

    public void deployConnector(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"AutoDeployment.deployConnector()");
        p.setProperty("ear_file", p.getProperty("rar_file"));
        Project pr = new Project();
        this.antSetupFromProps(p, pr);
        try {
            pr.executeTarget("-deploy");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new TSDeploymentException(t.getMessage());
        }
    }

    public void undeployConnector(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"AutoDeployment.undeployConnector()");
        p.setProperty("ear_file", p.getProperty("rar_file"));
        this.undeploy(p);
    }

    public boolean isConnectorDeployed(Properties p) throws TSDeploymentException {
        TestUtil.logHarness((String)"AutoDeployment.isConnectorDeployed()");
        p.setProperty("ear_file", p.getProperty("rar_file"));
        return this.isDeployed(p);
    }

    public String getAppClientArgs(Properties p) {
        String sAppName = null;
        Object executeArgs = p.getProperty("executeArgs");
        Object sApp = p.getProperty("ear_file");
        String sClientname = p.getProperty("client_name");
        if (((String)sApp).endsWith(".ear")) {
            sAppName = this.getAppNameFromApplicationXML((String)sApp);
        }
        String sTSDeploymentDir = ((String)sApp).substring(0, ((String)sApp).lastIndexOf(File.separator) + 1) + "ts_dep";
        if (sAppName == null) {
            sAppName = ((String)sApp).substring(((String)sApp).lastIndexOf(File.separator) + 1, ((String)sApp).lastIndexOf("."));
        }
        if (sAppName.startsWith("vi_built_")) {
            sAppName = sAppName.substring(9);
            sTSDeploymentDir = ((String)sApp).substring(0, ((String)sApp).lastIndexOf(File.separator) + 1) + "ts_dep_vi_built";
            sClientname = sClientname.substring(9);
        }
        sApp = sTSDeploymentDir + File.separator + sAppName + "Client.jar";
        executeArgs = executeArgs == null ? (String)sApp + ",arg=-name,arg=" + sClientname + " -classpath " + this.propMgr.getProperty("javaee.home", "/") + "/lib/gf-client.jar:" + (String)sApp + " org.glassfish.appclient.client.AppClientGroupFacade " : (String)sApp + ",arg=-name,arg=" + sClientname + " -classpath " + this.propMgr.getProperty("javaee.home", "/") + "/lib/gf-client.jar:" + (String)sApp + " org.glassfish.appclient.client.AppClientGroupFacade  " + (String)executeArgs;
        return executeArgs;
    }

    public Hashtable getInteropJNDINames(DeploymentInfo[] infoArray) {
        this.htJNDIRefs = new Hashtable();
        StringBuffer buf = null;
        if (TestUtil.harnessDebug) {
            for (int ii = 0; ii < infoArray.length; ++ii) {
                Hashtable jndiChanges;
                int i;
                buf = new StringBuffer("**** ii=" + ii + " ********************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append(new RuntimeInfo().getRuntimeInfo(infoArray[ii]) + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                buf.append("***************************************************************************************" + newLine);
                TestUtil.logHarnessDebug((String)buf.toString());
                List<Ejb> resources = infoArray[ii].getAppClientRuntimeDDs();
                for (i = 0; i < resources.size(); ++i) {
                    SunApplicationClient appResource = (SunApplicationClient)resources.get(i);
                    jndiChanges = this.checkJNDINames(appResource.getEjbRef());
                    if (jndiChanges.isEmpty()) continue;
                    this.htJNDIRefs.putAll(jndiChanges);
                }
                resources = infoArray[ii].getWebRuntimeDDs();
                for (i = 0; i < resources.size(); ++i) {
                    SunWebApp webResource = (SunWebApp)resources.get(i);
                    jndiChanges = this.checkJNDINames(webResource.getEjbRef());
                    if (jndiChanges.isEmpty()) continue;
                    this.htJNDIRefs.putAll(jndiChanges);
                }
                List ejbJars = infoArray[ii].getEjbRuntimeDDs();
                for (int y = 0; y < ejbJars.size(); ++y) {
                    SunEjbJar ejbJar = (SunEjbJar)ejbJars.get(y);
                    resources = ejbJar.getEnterpriseBeans().getEjb();
                    for (int i2 = 0; i2 < resources.size(); ++i2) {
                        Ejb ejbResource = resources.get(i2);
                        Hashtable jndiChanges2 = this.checkJNDINames(ejbResource.getEjbRef());
                        if (jndiChanges2.isEmpty()) continue;
                        this.htJNDIRefs.putAll(jndiChanges2);
                    }
                }
            }
        }
        buf = new StringBuffer("***** Returning the following Hashtable from SunRIDeployment.getInteropJNDINames *****" + newLine);
        buf.append("***************************************************************************************" + newLine);
        Enumeration e = this.htJNDIRefs.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            buf.append("Original value:  " + sKey + newLine);
            buf.append("Modified value:  " + (String)this.htJNDIRefs.get(sKey) + newLine);
        }
        buf.append("***************************************************************************************" + newLine);
        TestUtil.logHarnessDebug((String)buf.toString());
        return this.htJNDIRefs;
    }

    private void addJNDIName(String jndiName, Hashtable jndiChanges) {
        if (jndiName.startsWith("corbaname")) {
            int endPos = jndiName.lastIndexOf("#");
            String newJNDI = jndiName.substring(0, endPos) + "#" + jndiName.substring(endPos + 1);
            jndiChanges.put(jndiName, newJNDI);
            TestUtil.logHarnessDebug((String)("******** old JNDI name \"" + jndiName + "\", new JNDI name \"" + newJNDI + "\""));
        }
    }

    private Hashtable checkJNDINames(List ejbRefs) {
        Hashtable jndiChanges;
        block5: {
            Object o;
            block6: {
                block4: {
                    jndiChanges = new Hashtable();
                    if (ejbRefs == null || ejbRefs.size() == 0) {
                        return jndiChanges;
                    }
                    o = ejbRefs.get(0);
                    if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.EjbRef)) break block4;
                    for (int j = 0; j < ejbRefs.size(); ++j) {
                        com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.EjbRef ref = (com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.EjbRef)ejbRefs.get(j);
                        String jndiName = ref.getJndiName();
                        this.addJNDIName(jndiName, jndiChanges);
                    }
                    break block5;
                }
                if (!(o instanceof com.sun.ts.lib.implementation.sun.javaee.runtime.web.EjbRef)) break block6;
                for (int j = 0; j < ejbRefs.size(); ++j) {
                    com.sun.ts.lib.implementation.sun.javaee.runtime.web.EjbRef ref = (com.sun.ts.lib.implementation.sun.javaee.runtime.web.EjbRef)ejbRefs.get(j);
                    String jndiName = ref.getJndiName();
                    this.addJNDIName(jndiName, jndiChanges);
                }
                break block5;
            }
            if (!(o instanceof EjbRef)) break block5;
            for (int j = 0; j < ejbRefs.size(); ++j) {
                EjbRef ref = (EjbRef)ejbRefs.get(j);
                String jndiName = ref.getJndiName();
                this.addJNDIName(jndiName, jndiChanges);
            }
        }
        return jndiChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppNameFromApplicationXML(String archivePathAndName) {
        String appName = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(archivePathAndName);
            JarEntry appEntry = jarFile.getJarEntry("META-INF/application.xml");
            if (appEntry != null) {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(jarFile.getInputStream(appEntry));
                Element root = doc.getRootElement();
                appName = root.getChildTextNormalize("application-name", root.getNamespace());
            }
        }
        catch (Exception e) {
            TestUtil.logHarness((String)"Error parsing application.xml looking for application-name, returning null");
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        TestUtil.logHarness((String)("getAppNameFromApplicationXML() returning \"" + appName + "\""));
        return appName;
    }

    private void log(String s) {
        this.log.println("GF Deployment: " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerLogContents() {
        StringBuilder contents = new StringBuilder();
        String aFile = "";
        try {
            File serverLog = this.iPortingSet == 1 ? new File(new File(this.propMgr.getProperty("impl.vi.deploy.dir", "")).getParent() + File.separator + "logs" + File.separator + SERVER_LOG) : new File(new File(this.propMgr.getProperty("impl.ri.deploy.dir", "")).getParent() + File.separator + "logs" + File.separator + SERVER_LOG);
            int logLineCount = this.countLines(serverLog);
            contents.append("************************************************");
            contents.append(System.getProperty("line.separator"));
            contents.append("GLASSFISH SERVER LOG CONTENTS:  Last 200 lines");
            contents.append(serverLog.getPath());
            contents.append(System.getProperty("line.separator"));
            contents.append("************************************************");
            contents.append(System.getProperty("line.separator"));
            try (BufferedReader input = new BufferedReader(new FileReader(serverLog));){
                String line = null;
                int iCurrentLine = 1;
                System.err.println("line count = " + logLineCount);
                while ((line = input.readLine()) != null) {
                    if (iCurrentLine > logLineCount - 200) {
                        contents.append(iCurrentLine + ":  " + line);
                        contents.append(System.getProperty("line.separator"));
                    }
                    ++iCurrentLine;
                }
                contents.append("************************************************");
                contents.append(System.getProperty("line.separator"));
                contents.append("END OF GLASSFISH SERVER LOG CONTENTS");
                contents.append(serverLog.getPath());
                contents.append(System.getProperty("line.separator"));
                contents.append("************************************************");
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }

    private int countLines(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
        int lineCount = 0;
        char[] buffer = new char[4096];
        int charsRead = reader.read(buffer);
        while (charsRead >= 0) {
            for (int charIndex = 0; charIndex < charsRead; ++charIndex) {
                if (buffer[charIndex] != '\n') continue;
                ++lineCount;
            }
            charsRead = reader.read(buffer);
        }
        ((Reader)reader).close();
        return lineCount;
    }

    static {
        SERVER_LOG = "server.log";
        newLine = System.getProperty("line.separator", "\n");
        TestUtil.initJavaTest();
        TEMP_DIR = System.getProperty("java.io.tmpdir");
        if (TEMP_DIR != null && TEMP_DIR.endsWith(File.separator)) {
            TEMP_DIR = TEMP_DIR.substring(0, TEMP_DIR.length() - 1);
        }
    }
}

