/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.HandlerTracker;
import com.sun.ts.tests.jaxws.common.Handler_Util;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SOAPHandlerBase
implements SOAPHandler<SOAPMessageContext> {
    private int doingHandlerWork = 0;
    private int destroyCalled = 0;
    private static final String NAMESPACEURI = "http://dlhandlerservice.org/wsdl";
    private static final String PORT_NAME1 = "HelloPort";
    private String whichHandlerType = null;
    private String handlerName = null;
    private static final String JAXB_OBJECT_CLIENT_FACTORY = "com.sun.ts.tests.jaxws.sharedclients.dlhandlerclient.ObjectFactory";
    private static final String JAXB_OBJECT_SERVER_FACTORY = "com.sun.ts.tests.jaxws.sharedwebservices.dlhandlerservice.ObjectFactory";

    public void setWhichHandlerType(String w) {
        this.whichHandlerType = w;
    }

    public String getWhichHandlerType() {
        return this.whichHandlerType;
    }

    public void setHandlerName(String h) {
        this.handlerName = h;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void preinvoke() {
        ++this.doingHandlerWork;
        if (this.destroyCalled > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - Handler used after destroy called"));
        }
    }

    public void postinvoke() {
        this.doingHandlerWork = 0;
    }

    @PostConstruct
    public void myInit() {
        TestUtil.logTrace((String)("in " + this + ":myInit"));
        HandlerTracker.reportInit((Handler)this, "myInit");
    }

    @PreDestroy
    public void myDestroy() {
        TestUtil.logTrace((String)("in " + this + ":myDestroy"));
        if (this.doingHandlerWork > 0) {
            HandlerTracker.reportThrowable((Handler)this, new Exception("Violation of Handler Lifecycle - destroy called during handler usage"));
        }
        HandlerTracker.reportDestroy((Handler)this, "myDestroy");
        ++this.destroyCalled;
    }

    public Set<QName> getHeaders() {
        HandlerTracker.reportGetHeaders((Handler)this);
        return new HashSet<QName>();
    }

    private JAXBContext createJAXBContext() {
        Class<?> c = null;
        JAXBContext jbc = null;
        try {
            if (this.whichHandlerType.equals("Client")) {
                TestUtil.logTrace((String)"Getting the object factory:com.sun.ts.tests.jaxws.sharedclients.dlhandlerclient.ObjectFactory");
                c = Class.forName(JAXB_OBJECT_CLIENT_FACTORY);
            } else {
                TestUtil.logTrace((String)"Getting the object factory:com.sun.ts.tests.jaxws.sharedwebservices.dlhandlerservice.ObjectFactory");
                c = Class.forName(JAXB_OBJECT_SERVER_FACTORY);
            }
            jbc = JAXBContext.newInstance((Class[])new Class[]{c});
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return jbc;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        System.out.println("in " + this + ":handleMessage");
        TestUtil.logTrace((String)("in " + this + ":handleMessage"));
        try {
            this.preinvoke();
            Handler_Util.setTraceFlag(Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            Handler_Util.initTestUtil((Handler)this, Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnessloghost"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogport"), Handler_Util.getValueFromMsg((Handler)this, (MessageContext)context, "harnesslogtraceflag"));
            String direction = Handler_Util.getDirection((MessageContext)context);
            if (!Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "GetTrackerData")) {
                HandlerTracker.reportHandleMessage((Handler)this, direction);
                if (Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "SOAPTest</testType>")) {
                    if (Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "MessageContextTest")) {
                        this.doSOAPMessageContext(context, direction);
                        this.doMessageContext(context, direction);
                    } else if (Handler_Util.checkForMsg((Handler)this, (MessageContext)context, "ContextPropertiesTest")) {
                        this.doContextProperties(context, direction);
                    }
                }
            } else {
                TestUtil.logTrace((String)"found GetTrackerData message, handler will ignore");
            }
        }
        catch (Exception e) {
            HandlerTracker.reportThrowable((Handler)this, e);
        }
        finally {
            this.postinvoke();
        }
        System.out.println("exiting " + this + ":handleMessage");
        TestUtil.logTrace((String)("exiting " + this + ":handleMessage"));
        return true;
    }

    public void close(MessageContext context) {
        TestUtil.logTrace((String)("in " + this + ":close"));
        try {
            this.preinvoke();
            HandlerTracker.reportClose((Handler)this);
        }
        finally {
            this.postinvoke();
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        System.out.println("in " + this + ":handleFault");
        TestUtil.logTrace((String)("in " + this + ":handleFault"));
        try {
            this.preinvoke();
            HandlerTracker.reportHandleFault((Handler)this);
        }
        finally {
            this.postinvoke();
        }
        System.out.println("exiting " + this + ":handleFault");
        TestUtil.logTrace((String)("exiting " + this + ":handleFault"));
        return true;
    }

    private void doContextProperties(SOAPMessageContext context, String direction) {
        TestUtil.logTrace((String)"in doSOAPMessageContext");
        TestUtil.logTrace((String)("direction=" + direction));
        TestUtil.logTrace((String)("handlerName=" + this.handlerName));
        if (this.handlerName.equals("ClientSOAPHandler2") || this.handlerName.equals("ServerSOAPHandler2")) {
            Map m1 = null;
            String attachmentProp = "";
            if (direction.equals("Outbound")) {
                m1 = (Map)context.get((Object)"jakarta.xml.ws.binding.attachments.outbound");
                attachmentProp = "SOAPMessageContext.OUTBOUND_MESSAGE_ATTACHMENTS";
            } else {
                m1 = (Map)context.get((Object)"jakarta.xml.ws.binding.attachments.inbound");
                attachmentProp = "SOAPMessageContext.INBOUND_MESSAGE_ATTACHMENTS";
            }
            Object sTmp = "";
            int cnt = 0;
            Iterator iterator = null;
            try {
                if (m1 != null) {
                    if (m1.size() > 0) {
                        for (String key : m1.keySet()) {
                            TestUtil.logTrace((String)("request attachments key[" + cnt + "]=" + key));
                            sTmp = "key[" + cnt + "]=" + key;
                            HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, (String)sTmp);
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            if (direction.equals("Outbound")) {
                m1 = (Map)context.get((Object)"jakarta.xml.ws.binding.attachments.outbound");
                attachmentProp = "MessageContext.OUTBOUND_MESSAGE_ATTACHMENTS";
            } else {
                m1 = (Map)context.get((Object)"jakarta.xml.ws.binding.attachments.inbound");
                attachmentProp = "MessageContext.INBOUND_MESSAGE_ATTACHMENTS";
            }
            cnt = 0;
            iterator = null;
            try {
                if (m1 != null) {
                    if (m1.size() > 0) {
                        for (String key : m1.keySet()) {
                            TestUtil.logTrace((String)("request attachments key[" + cnt + "]=" + key));
                            sTmp = "key[" + cnt + "]=" + key;
                            HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, (String)sTmp);
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    HandlerTracker.reportProperties((Handler)this, direction, attachmentProp, "null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            String ss = (String)context.get((Object)"jakarta.xml.ws.http.request.method");
            if (ss != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.HTTP_REQUEST_METHOD", ss);
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.HTTP_REQUEST_METHOD", "null");
            }
            ss = (String)context.get((Object)"jakarta.xml.ws.http.request.method");
            if (ss != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_REQUEST_METHOD", ss);
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_REQUEST_METHOD", "null");
            }
            Integer ii = (Integer)context.get((Object)"jakarta.xml.ws.http.response.code");
            if (ii != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.HTTP_RESPONSE_CODE", ii.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.HTTP_RESPONSE_CODE", "null");
            }
            ii = (Integer)context.get((Object)"jakarta.xml.ws.http.response.code");
            if (ii != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_RESPONSE_CODE", ii.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_RESPONSE_CODE", "null");
            }
            Map m2 = (Map)context.get((Object)"jakarta.xml.ws.http.request.headers");
            StringBuffer sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("request headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.HTTP_REQUEST_HEADERS", sb.toString());
            m2 = (Map)context.get((Object)"jakarta.xml.ws.http.request.headers");
            sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("request headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_REQUEST_HEADERS", sb.toString());
            m2 = (Map)context.get((Object)"jakarta.xml.ws.http.response.headers");
            sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("response headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.HTTP_RESPONSE_HEADERS", sb.toString());
            m2 = (Map)context.get((Object)"jakarta.xml.ws.http.response.headers");
            sb = new StringBuffer();
            cnt = 0;
            iterator = null;
            try {
                if (m2 != null) {
                    if (m2.size() > 0) {
                        for (String key : m2.keySet()) {
                            TestUtil.logTrace((String)("response headers key[" + cnt + "]=" + key));
                            sb.append("key[" + cnt + "]=" + key + "|");
                            ++cnt;
                        }
                    } else {
                        TestUtil.logTrace((String)"empty");
                        sb.append("empty");
                    }
                } else {
                    TestUtil.logTrace((String)"null");
                    sb.append("null");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
            HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.HTTP_RESPONSE_HEADERS", sb.toString());
            Object oo = context.get((Object)"jakarta.xml.ws.servlet.request");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.SERVLET_REQUEST", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.SERVLET_REQUEST", "null");
            }
            oo = context.get((Object)"jakarta.xml.ws.servlet.request");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_REQUEST", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_REQUEST", "null");
            }
            oo = context.get((Object)"jakarta.xml.ws.servlet.response");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.SERVLET_RESPONSE", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.SERVLET_RESPONSE", "null");
            }
            oo = context.get((Object)"jakarta.xml.ws.servlet.response");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_RESPONSE", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_RESPONSE", "null");
            }
            oo = context.get((Object)"jakarta.xml.ws.servlet.context");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.SERVLET_CONTEXT", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "SOAPMessageContext.SERVLET_CONTEXT", "null");
            }
            oo = context.get((Object)"jakarta.xml.ws.servlet.context");
            if (oo != null) {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_CONTEXT", oo.toString());
            } else {
                HandlerTracker.reportProperties((Handler)this, direction, "MessageContext.SERVLET_CONTEXT", "null");
            }
        }
    }

    private void doSOAPMessageContext(SOAPMessageContext context, String direction) {
        TestUtil.logTrace((String)"in doSOAPMessageContext");
        TestUtil.logTrace((String)("direction=" + direction));
        TestUtil.logTrace((String)("handlerName" + this.handlerName));
        if (this.handlerName.equals("ClientSOAPHandler2") || this.handlerName.equals("ServerSOAPHandler2")) {
            TestUtil.logTrace((String)"calling context.getMessage()");
            SOAPMessage sm = context.getMessage();
            if (sm != null) {
                HandlerTracker.reportSMCGetMessage((Handler)this, direction, JAXWS_Util.getSOAPMessageAsString(sm));
            } else {
                HandlerTracker.reportSMCGetMessage((Handler)this, direction, "null");
            }
            context.setMessage(sm);
            HandlerTracker.reportSMCSetMessage((Handler)this, direction);
            HandlerTracker.reportSMCGetRoles((Handler)this, direction, context.getRoles());
            JAXBContext jbc = this.createJAXBContext();
            if (jbc != null) {
                QName qname = new QName(NAMESPACEURI, PORT_NAME1);
                TestUtil.logTrace((String)("qname=" + qname));
                HandlerTracker.reportSMCGetHeaders((Handler)this, direction, context.getHeaders(qname, jbc, true));
            } else {
                throw new WebServiceException(direction + this + "The JAXBContext returned was null");
            }
        }
    }

    private void doMessageContext(SOAPMessageContext context, String direction) {
        String whichDirection = direction.toUpperCase();
        TestUtil.logTrace((String)"in doMessageContext");
        TestUtil.logTrace((String)("whichDirection=" + whichDirection));
        TestUtil.logTrace((String)("handlerName=" + this.handlerName));
        if (this.handlerName.equals("ClientSOAPHandler2") || this.handlerName.equals("ServerSOAPHandler2")) {
            HandlerTracker.reportComment((Handler)this, "BeginSOAPMessageContextCallbackInvocations");
            TestUtil.logTrace((String)("whichHandlerType=" + this.whichHandlerType));
            if (this.whichHandlerType.equals("Client")) {
                HandlerTracker.reportGet((Handler)this, this.whichHandlerType + "To" + this.whichHandlerType + "Prop", (String)context.get((Object)(this.whichHandlerType + "To" + this.whichHandlerType + "Prop")));
                Object tmp = (String)context.get((Object)(this.whichHandlerType + "To" + this.whichHandlerType + "Prop"));
                tmp = (String)tmp + whichDirection + this.handlerName;
                context.put((Object)(this.whichHandlerType + "To" + this.whichHandlerType + "Prop"), tmp);
                HandlerTracker.reportPut((Handler)this, this.whichHandlerType + "To" + this.whichHandlerType + "Prop", (String)tmp);
                context.setScope(this.whichHandlerType + "To" + this.whichHandlerType + "Prop", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, this.whichHandlerType + "To" + this.whichHandlerType + "Prop", MessageContext.Scope.APPLICATION.toString());
            } else {
                Object tmp = "";
                if (direction.equals("Outbound")) {
                    HandlerTracker.reportGet((Handler)this, "Handler" + this.whichHandlerType + "HandlerProp", (String)context.get((Object)("Handler" + this.whichHandlerType + "HandlerProp")));
                    tmp = (String)context.get((Object)("Handler" + this.whichHandlerType + "HandlerProp"));
                }
                tmp = (String)tmp + whichDirection + this.handlerName;
                context.put((Object)("Handler" + this.whichHandlerType + "HandlerProp"), tmp);
                HandlerTracker.reportPut((Handler)this, "Handler" + this.whichHandlerType + "HandlerProp", (String)tmp);
                context.setScope("Handler" + this.whichHandlerType + "HandlerProp", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, "Handler" + this.whichHandlerType + "HandlerProp", MessageContext.Scope.APPLICATION.toString());
            }
            HandlerTracker.reportComment((Handler)this, "EndMessageContextCallbackInvocations");
        } else if (this.handlerName.equals("ClientSOAPHandler1") || this.handlerName.equals("ServerSOAPHandler1")) {
            HandlerTracker.reportComment((Handler)this, "BeginSOAPMessageContextCallbackInvocations");
            if (direction.equals("Outbound")) {
                HandlerTracker.reportComment((Handler)this, "Set Properties and see that Handler3 can access them");
                context.put((Object)(whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler1"), (Object)"SetByHandler1");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler1", "SetByHandler1");
                context.put((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1"), (Object)"SetByHandler1");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1", "SetByHandler1");
                context.setScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1", MessageContext.Scope.APPLICATION.toString());
                context.put((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1"), (Object)"SetByHandler1");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1", "SetByHandler1");
                context.setScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1", MessageContext.Scope.HANDLER);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1", MessageContext.Scope.HANDLER.toString());
            } else if (direction.equals("Inbound")) {
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler3", (String)context.get((Object)(whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler3")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3", (String)context.get((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3", (String)context.get((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3")));
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler3", context.getScope(whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler3").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3", context.getScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3", context.getScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3").toString());
            }
            HandlerTracker.reportComment((Handler)this, "EndMessageContextCallbackInvocations");
        } else if (this.handlerName.equals("ClientSOAPHandler3") || this.handlerName.equals("ServerSOAPHandler3")) {
            HandlerTracker.reportComment((Handler)this, "BeginSOAPMessageContextCallbackInvocations");
            if (direction.equals("Outbound")) {
                TestUtil.logTrace((String)("whichHandlerType=" + this.whichHandlerType));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler1", (String)context.get((Object)(whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler1")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1", (String)context.get((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1")));
                HandlerTracker.reportGet((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1", (String)context.get((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1")));
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler1", context.getScope(whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler1").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1", context.getScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler1").toString());
                HandlerTracker.reportGetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1", context.getScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler1").toString());
            } else if (direction.equals("Inbound")) {
                context.put((Object)(whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler3"), (Object)"SetByHandler3");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "SOAPCrossHandlerPropSetByHandler3", "SetByHandler3");
                context.put((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3"), (Object)"SetByHandler3");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3", "SetByHandler3");
                context.setScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3", MessageContext.Scope.APPLICATION);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeAppPropSetByHandler3", MessageContext.Scope.APPLICATION.toString());
                context.put((Object)(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3"), (Object)"SetByHandler3");
                HandlerTracker.reportPut((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3", "SetByHandler3");
                context.setScope(whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3", MessageContext.Scope.HANDLER);
                HandlerTracker.reportSetScope((Handler)this, whichDirection + this.whichHandlerType + "SOAPMessageScopeHandlerPropSetByHandler3", MessageContext.Scope.HANDLER.toString());
            }
            HandlerTracker.reportComment((Handler)this, "EndSOAPMessageContextCallbackInvocations");
        }
    }
}

