/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.common;

import ee.jakarta.tck.jsonp.api.common.JsonValueType;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonPatch;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Logger;

public class SimpleValues {
    private static final Logger LOGGER = Logger.getLogger(SimpleValues.class.getName());
    public static final String STR_NAME = "address";
    public static final String STR_PATH = "/address";
    public static final String STR_VALUE = "In a galaxy far far away";
    public static final String STR_VALUE2 = "In a land of myth";
    public static final String INT_NAME = "age";
    public static final String INT_PATH = "/age";
    public static final int INT_VALUE = 42;
    public static final int INT_VALUE2 = 32;
    public static final String BOOL_NAME = "married";
    public static final String BOOL_PATH = "/married";
    public static final boolean BOOL_VALUE = true;
    public static final boolean BOOL_VALUE2 = false;
    public static final String OBJ_NAME = "wife";
    public static final String OBJ_PATH = "/wife";
    public static final JsonObject OBJ_VALUE = SimpleValues.createSimpleObject(new String[]{"name", "age"}, new Object[]{"Sarah Connor", 32});
    public static final JsonObject OBJ_VALUE2 = SimpleValues.createSimpleObject(new String[]{"name", "age"}, new Object[]{"Kyle Reese", 35});
    public static final String DEF_NAME = "name";
    public static final String DEF_PATH = "/name";
    public static final String DEF_VALUE = "John Smith";
    public static final String DEF_OBJ_NAME = "child";
    public static final String DEF_OBJ_PATH = "/child";
    public static final JsonObject DEF_OBJ_VALUE = SimpleValues.createSimpleObject(new String[]{"name", "age"}, new Object[]{"John Connor", 6});
    public static final JsonObject DEF_OBJ_VALUE2 = SimpleValues.createSimpleObject(new String[]{"name", "age"}, new Object[]{"John Smith", 6});
    public static final String STR_VALUE_1 = "First value";
    public static final String STR_VALUE_2 = "Second value";
    public static final String STR_VALUE_3 = "Third value";
    public static final String STR_VALUE_4 = "Fourth value";
    public static final String STR_VALUE_5 = "Fifth value";
    public static final String STR_VALUE_6 = "Sixth value";
    public static final String STR_VALUE_7 = "Seventh value";
    public static final int INT_VALUE_1 = 1;
    public static final int INT_VALUE_2 = 2;
    public static final int INT_VALUE_3 = 3;
    public static final int INT_VALUE_4 = 4;
    public static final int INT_VALUE_5 = 5;
    public static final JsonObject OBJ_VALUE_1 = SimpleValues.createSimpleObject(new String[]{"first"}, new String[]{"First value"});
    public static final JsonObject OBJ_VALUE_2 = SimpleValues.createSimpleObject(new String[]{"second"}, new String[]{"Second value"});
    public static final JsonObject OBJ_VALUE_3 = SimpleValues.createSimpleObject(new String[]{"third"}, new String[]{"Third value"});
    public static final JsonObject OBJ_VALUE_4 = SimpleValues.createSimpleObject(new String[]{"fourth"}, new String[]{"Fourth value"});
    public static final JsonObject OBJ_VALUE_5 = SimpleValues.createSimpleObject(new String[]{"fifth"}, new String[]{"Fifth value"});
    public static final boolean BOOL_TRUE = true;
    public static final boolean BOOL_FALSE = false;
    public static final long LNG_VALUE = 9223372036854775765L;
    public static final BigInteger BIN_VALUE = new BigInteger("123456789012345678901234567890");
    public static final double DBL_VALUE = 3.441073578556931E305;
    public static final BigDecimal BDC_VALUE = new BigDecimal(new BigInteger("1234567890123456789012345678901234567890"), 10);
    public static final String NULL = "null";

    public static JsonObject createEmptyObject() {
        return Json.createObjectBuilder().build();
    }

    public static JsonObject createSimpleObjectStr() {
        return Json.createObjectBuilder().add(STR_NAME, STR_VALUE).build();
    }

    public static JsonObject createSimpleObjectInt() {
        return Json.createObjectBuilder().add(INT_NAME, 42).build();
    }

    public static JsonObject createSimpleObjectBool() {
        return Json.createObjectBuilder().add(BOOL_NAME, true).build();
    }

    public static JsonObject createSimpleObjectObject() {
        return Json.createObjectBuilder().add(OBJ_NAME, (JsonValue)OBJ_VALUE).build();
    }

    public static JsonObject createPatchRemoveStr() {
        return Json.createObjectBuilder().add(STR_NAME, JsonValue.NULL).build();
    }

    public static JsonObject createPatchRemoveInt() {
        return Json.createObjectBuilder().add(INT_NAME, JsonValue.NULL).build();
    }

    public static JsonObject createPatchRemoveBool() {
        return Json.createObjectBuilder().add(BOOL_NAME, JsonValue.NULL).build();
    }

    public static JsonObject createPatchRemoveObject() {
        return Json.createObjectBuilder().add(OBJ_NAME, JsonValue.NULL).build();
    }

    public static JsonArray createEmptyArray() {
        return Json.createArrayBuilder().build();
    }

    public static JsonArray createEmptyArrayWithStr() {
        return Json.createArrayBuilder().add(STR_VALUE).build();
    }

    public static JsonArray createEmptyArrayWithInt() {
        return Json.createArrayBuilder().add(42).build();
    }

    public static JsonArray createEmptyArrayWithBool() {
        return Json.createArrayBuilder().add(true).build();
    }

    public static JsonArray createEmptyArrayWithObject() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE).build();
    }

    public static JsonObject createSimpleObject() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).build();
    }

    public static JsonObject createSimpleObjectWithStr() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(STR_NAME, STR_VALUE).build();
    }

    public static JsonObject createSimpleObjectReplaceStr() {
        return Json.createObjectBuilder().add(STR_NAME, STR_VALUE2).build();
    }

    public static JsonObject createSimpleObjectMoveStr() {
        return Json.createObjectBuilder().add(DEF_NAME, STR_VALUE).build();
    }

    public static JsonObject createSimpleObjectCopyStr() {
        return Json.createObjectBuilder().add(STR_NAME, STR_VALUE).add(DEF_NAME, STR_VALUE).build();
    }

    public static JsonObject createSimpleObjectWithInt() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(INT_NAME, 42).build();
    }

    public static JsonObject createSimpleObjectReplaceInt() {
        return Json.createObjectBuilder().add(INT_NAME, 32).build();
    }

    public static JsonObject createSimpleObjectMoveInt() {
        return Json.createObjectBuilder().add(DEF_NAME, 42).build();
    }

    public static JsonObject createSimpleObjectCopyInt() {
        return Json.createObjectBuilder().add(INT_NAME, 42).add(DEF_NAME, 42).build();
    }

    public static JsonObject createSimpleObjectWithBool() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(BOOL_NAME, true).build();
    }

    public static JsonObject createSimpleObjectReplaceBool() {
        return Json.createObjectBuilder().add(BOOL_NAME, false).build();
    }

    public static JsonObject createSimpleObjectMoveBool() {
        return Json.createObjectBuilder().add(DEF_NAME, true).build();
    }

    public static JsonObject createSimpleObjectCopyBool() {
        return Json.createObjectBuilder().add(BOOL_NAME, true).add(DEF_NAME, true).build();
    }

    public static JsonObject createCompoundObject() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(DEF_OBJ_NAME, (JsonValue)DEF_OBJ_VALUE).build();
    }

    public static JsonObject createCompoundObjectWithObject() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(DEF_OBJ_NAME, (JsonValue)DEF_OBJ_VALUE).add(OBJ_NAME, (JsonValue)OBJ_VALUE).build();
    }

    public static JsonObject createCompoundObjectReplaceObject() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(DEF_OBJ_NAME, (JsonValue)DEF_OBJ_VALUE).add(OBJ_NAME, (JsonValue)OBJ_VALUE2).build();
    }

    public static JsonObject createCompoundObjectMoveValue() {
        return Json.createObjectBuilder().add(DEF_OBJ_NAME, (JsonValue)DEF_OBJ_VALUE2).build();
    }

    public static JsonObject createCompoundObjectCopyValue() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(DEF_OBJ_NAME, (JsonValue)DEF_OBJ_VALUE2).build();
    }

    public static JsonObject createSimpleObjectMoveObject() {
        return Json.createObjectBuilder().add(DEF_NAME, (JsonValue)OBJ_VALUE).build();
    }

    public static JsonObject createSimpleObjectCopyObject() {
        return Json.createObjectBuilder().add(OBJ_NAME, (JsonValue)OBJ_VALUE).add(DEF_NAME, (JsonValue)OBJ_VALUE).build();
    }

    public static JsonObject createCompoundObjectWithObjectReplaced() {
        return Json.createObjectBuilder().add(DEF_NAME, DEF_VALUE).add(DEF_OBJ_NAME, (JsonValue)SimpleValues.createSimpleStringArray5()).build();
    }

    public static JsonObject createSimpleObject(String[] names, Object[] values) {
        if (names.length != values.length) {
            throw new IllegalArgumentException("Number of paths does not match number of indexes");
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        block6: for (int i = 0; i < names.length; ++i) {
            switch (JsonValueType.getType(values[i].getClass())) {
                case String: {
                    builder = builder.add(names[i], (String)values[i]);
                    continue block6;
                }
                case Integer: {
                    builder = builder.add(names[i], ((Integer)values[i]).intValue());
                    continue block6;
                }
                case Boolean: {
                    builder = builder.add(names[i], ((Boolean)values[i]).booleanValue());
                    continue block6;
                }
                case JsonValue: {
                    builder = builder.add(names[i], (JsonValue)values[i]);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Value does not match known JSON value type");
                }
            }
        }
        return builder.build();
    }

    public static JsonArray createStringArray(String ... values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        if (values != null) {
            for (String value : values) {
                builder = builder.add(value);
            }
        }
        return builder.build();
    }

    public static JsonArray createStringArray1() {
        return Json.createArrayBuilder().add(STR_VALUE_1).build();
    }

    public static JsonArray createSimpleStringArrayWithStrBefore() {
        return Json.createArrayBuilder().add(STR_VALUE).add(STR_VALUE_1).build();
    }

    public static JsonArray createSimpleStringArrayWithStrAfter() {
        return Json.createArrayBuilder().add(STR_VALUE_1).add(STR_VALUE).build();
    }

    public static JsonArray createSimpleStringArrayReplaceStr() {
        return Json.createArrayBuilder().add(STR_VALUE).build();
    }

    public static JsonArray createStringArray2() {
        return Json.createArrayBuilder().add(STR_VALUE_2).add(STR_VALUE_4).build();
    }

    public static JsonArray createStringArray2R() {
        return Json.createArrayBuilder().add(STR_VALUE_4).add(STR_VALUE_2).build();
    }

    public static JsonArray createStringInnerArray2() {
        return Json.createArrayBuilder().add(STR_VALUE_6).add(STR_VALUE_7).build();
    }

    public static JsonArray createStringArray2Copy1to0() {
        return Json.createArrayBuilder().add(STR_VALUE_4).add(STR_VALUE_2).add(STR_VALUE_4).build();
    }

    public static JsonArray createStringArray2Copy0to2() {
        return Json.createArrayBuilder().add(STR_VALUE_2).add(STR_VALUE_4).add(STR_VALUE_2).build();
    }

    public static JsonArray createStringArray2Copy0to1() {
        return Json.createArrayBuilder().add(STR_VALUE_2).add(STR_VALUE_2).add(STR_VALUE_4).build();
    }

    public static JsonArray createSimpleStringArray5() {
        return Json.createArrayBuilder().add(STR_VALUE_1).add(STR_VALUE_2).add(STR_VALUE_3).add(STR_VALUE_4).add(STR_VALUE_5).build();
    }

    public static JsonArray createSimpleStringArray5R() {
        return Json.createArrayBuilder().add(STR_VALUE_5).add(STR_VALUE_4).add(STR_VALUE_3).add(STR_VALUE_2).add(STR_VALUE_1).build();
    }

    public static JsonArray createStringArray2WithStringArrayInTheMiddle() {
        return Json.createArrayBuilder().add(STR_VALUE_2).add((JsonValue)SimpleValues.createStringInnerArray2()).add(STR_VALUE_4).build();
    }

    public static JsonArray createIntArray1() {
        return Json.createArrayBuilder().add(1).build();
    }

    public static JsonArray createSimpleIntArrayWithIntBefore() {
        return Json.createArrayBuilder().add(42).add(1).build();
    }

    public static JsonArray createSimpleIntArrayWithIntAfter() {
        return Json.createArrayBuilder().add(1).add(42).build();
    }

    public static JsonArray createSimpleIntArrayReplaceInt() {
        return Json.createArrayBuilder().add(42).build();
    }

    public static JsonArray createIntArray2() {
        return Json.createArrayBuilder().add(2).add(4).build();
    }

    public static JsonArray createIntArray2R() {
        return Json.createArrayBuilder().add(4).add(2).build();
    }

    public static JsonArray createIntArray2Copy1to0() {
        return Json.createArrayBuilder().add(4).add(2).add(4).build();
    }

    public static JsonArray createIntArray2Copy0to2() {
        return Json.createArrayBuilder().add(2).add(4).add(2).build();
    }

    public static JsonArray createIntArray2Copy0to1() {
        return Json.createArrayBuilder().add(2).add(2).add(4).build();
    }

    public static JsonArray createSimpleIntArray5() {
        return Json.createArrayBuilder().add(1).add(2).add(3).add(4).add(5).build();
    }

    public static JsonArray createSimpleIntArray5R() {
        return Json.createArrayBuilder().add(5).add(4).add(3).add(2).add(1).build();
    }

    public static JsonArray createBoolArray1() {
        return Json.createArrayBuilder().add(true).build();
    }

    public static JsonArray createSimpleBoolArrayWithBoolBefore() {
        return Json.createArrayBuilder().add(false).add(true).build();
    }

    public static JsonArray createSimpleBoolArrayWithBoolAfter() {
        return Json.createArrayBuilder().add(true).add(false).build();
    }

    public static JsonArray createSimpleBoolArrayReplaceBool() {
        return Json.createArrayBuilder().add(false).build();
    }

    public static JsonArray createBoolArray2() {
        return Json.createArrayBuilder().add(true).add(false).build();
    }

    public static JsonArray createBoolArray2R() {
        return Json.createArrayBuilder().add(false).add(true).build();
    }

    public static JsonArray createBoolArray2Copy1to0() {
        return Json.createArrayBuilder().add(false).add(true).add(false).build();
    }

    public static JsonArray createBoolArray2Copy0to2() {
        return Json.createArrayBuilder().add(true).add(false).add(true).build();
    }

    public static JsonArray createBoolArray2Copy0to1() {
        return Json.createArrayBuilder().add(true).add(true).add(false).build();
    }

    public static JsonArray createSimpleBoolArray5() {
        return Json.createArrayBuilder().add(false).add(true).add(true).add(false).add(true).build();
    }

    public static JsonArray createSimpleBoolArray5R() {
        return Json.createArrayBuilder().add(true).add(false).add(true).add(true).add(false).build();
    }

    public static JsonArray createObjectArray1() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_1).build();
    }

    public static JsonArray createSimpleObjectArrayWithObjectBefore() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE).add((JsonValue)OBJ_VALUE_1).build();
    }

    public static JsonArray createSimpleObjectArrayWithObjectAfter() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_1).add((JsonValue)OBJ_VALUE).build();
    }

    public static JsonArray createSimpleObjectArrayReplaceObject() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE).build();
    }

    public static JsonArray createObjectArray2() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_4).build();
    }

    public static JsonArray createObjectArray2R() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_4).add((JsonValue)OBJ_VALUE_2).build();
    }

    public static JsonArray createObjectArray2Copy1to0() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_4).add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_4).build();
    }

    public static JsonArray createObjectArray2Copy0to2() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_4).add((JsonValue)OBJ_VALUE_2).build();
    }

    public static JsonArray createObjectArray2Copy0to1() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_4).build();
    }

    public static JsonArray createSimpleObjectArray5() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_1).add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_3).add((JsonValue)OBJ_VALUE_4).add((JsonValue)OBJ_VALUE_5).build();
    }

    public static JsonArray createSimpleObjectArray5R() {
        return Json.createArrayBuilder().add((JsonValue)OBJ_VALUE_5).add((JsonValue)OBJ_VALUE_4).add((JsonValue)OBJ_VALUE_3).add((JsonValue)OBJ_VALUE_2).add((JsonValue)OBJ_VALUE_1).build();
    }

    public static JsonValue toJsonValue(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        switch (JsonValueType.getType(value.getClass())) {
            case String: {
                return Json.createValue((String)((String)value));
            }
            case Integer: {
                return Json.createValue((int)((Integer)value));
            }
            case Long: {
                return Json.createValue((long)((Long)value));
            }
            case BigInteger: {
                return Json.createValue((BigInteger)((BigInteger)value));
            }
            case Double: {
                return Json.createValue((double)((Double)value));
            }
            case BigDecimal: {
                return Json.createValue((BigDecimal)((BigDecimal)value));
            }
            case Boolean: {
                return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case JsonValue: {
                return (JsonValue)value;
            }
            case Null: {
                return JsonValue.NULL;
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    public static String jsonData(JsonValue value) {
        StringWriter strWriter = new StringWriter();
        try (JsonWriter writer = Json.createWriter((Writer)strWriter);){
            writer.write(value);
        }
        catch (JsonException ex) {
            LOGGER.info("Could not initialize JSON data: " + ex.getLocalizedMessage());
            throw ex;
        }
        return strWriter.toString();
    }

    public static JsonValue patchApply(JsonPatch patch, JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                return patch.apply((JsonStructure)((JsonObject)value));
            }
            case ARRAY: {
                return patch.apply((JsonStructure)((JsonArray)value));
            }
        }
        throw new IllegalArgumentException("Unsupported JSON value type to be pached");
    }

    public static JsonValue booleanValue(boolean value) {
        return value ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private SimpleValues() {
    }
}

