/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonnumbertests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.JsonNumber;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonNumberEqualsTest() {
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonNumber 1 for testing");
            JsonNumber number1 = JSONP_Util.createJsonNumber((int)10);
            LOGGER.info("number1=" + JSONP_Util.toStringJsonNumber((JsonNumber)number1));
            LOGGER.info("Create sample JsonNumber 2 for testing");
            JsonNumber number2 = JSONP_Util.createJsonNumber((int)10);
            LOGGER.info("number2=" + JSONP_Util.toStringJsonNumber((JsonNumber)number2));
            LOGGER.info("Call JsonNumber.equals() to compare 2 equal JsonNumbers and expect true");
            if (number1.equals((Object)number2)) {
                LOGGER.info("JsonNumbers are equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonNumbers are not equal - unexpected.");
            }
            LOGGER.info("Create sample JsonNumber 1 for testing");
            number1 = JSONP_Util.createJsonNumber((int)10);
            LOGGER.info("number1=" + JSONP_Util.toStringJsonNumber((JsonNumber)number1));
            LOGGER.info("Create sample JsonNumber 2 for testing");
            number2 = JSONP_Util.createJsonNumber((double)10.25);
            LOGGER.info("number2=" + JSONP_Util.toStringJsonNumber((JsonNumber)number2));
            LOGGER.info("Call JsonNumber.equals() to compare 2 equal JsonNumbers and expect false");
            if (!number1.equals((Object)number2)) {
                LOGGER.info("JsonNumbers are not equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonNumbers are equal - unexpected.");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonNumberEqualsTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonNumberEqualsTest Failed");
    }

    @Test
    public void jsonNumberHashCodeTest() {
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonNumber 1 for testing");
            JsonNumber number1 = JSONP_Util.createJsonNumber((int)10);
            LOGGER.info("number1=" + JSONP_Util.toStringJsonNumber((JsonNumber)number1));
            LOGGER.info("number1.hashCode()=" + number1.hashCode());
            LOGGER.info("Create sample JsonNumber 2 for testing");
            JsonNumber number2 = JSONP_Util.createJsonNumber((int)10);
            LOGGER.info("number2=" + JSONP_Util.toStringJsonNumber((JsonNumber)number2));
            LOGGER.info("number2.hashCode()=" + number2.hashCode());
            LOGGER.info("Call JsonNumber.hashCode() to compare 2 equal JsonNumbers and expect true");
            if (number1.hashCode() == number2.hashCode()) {
                LOGGER.info("JsonNumbers hashCode are equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonNumbers hashCode are not equal - unexpected.");
            }
            LOGGER.info("Create sample JsonNumber 1 for testing");
            number1 = JSONP_Util.createJsonNumber((int)10);
            LOGGER.info("number1=" + JSONP_Util.toStringJsonNumber((JsonNumber)number1));
            LOGGER.info("number1.hashCode()=" + number1.hashCode());
            LOGGER.info("Create sample JsonNumber 2 for testing");
            number2 = JSONP_Util.createJsonNumber((double)10.25);
            LOGGER.info("number2=" + JSONP_Util.toStringJsonNumber((JsonNumber)number2));
            LOGGER.info("number2.hashCode()=" + number2.hashCode());
            LOGGER.info("Call JsonNumber.hashCode() to compare 2 equal JsonNumbers and expect false");
            if (number1.hashCode() != number2.hashCode()) {
                LOGGER.info("JsonNumbers hashCode are not equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonNumbers hashCode are equal - unexpected.");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonNumberHashCodeTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonNumberHashCodeTest Failed");
    }

    @Test
    public void jsonNumberIsIntegralTest() {
        boolean pass = true;
        Object jsonNumber = null;
        try {
            JsonNumber number1 = JSONP_Util.createJsonNumber((int)123);
            if (!JSONP_Util.assertEqualsJsonNumberType((boolean)number1.isIntegral(), (boolean)true)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals((int)123, (int)number1.intValue())) {
                pass = false;
            }
            JsonNumber number2 = JSONP_Util.createJsonNumber((double)12345.45);
            if (!JSONP_Util.assertEqualsJsonNumberType((boolean)number2.isIntegral(), (boolean)false)) {
                pass = false;
            } else if (!JSONP_Util.assertEquals((double)12345.45, (double)number2.doubleValue())) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonNumberIsIntegralTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonNumberIsIntegralTest Failed");
    }
}

