/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.mergetests;

import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.mergetests.MergeCommon;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class MergeRemoveValue
extends MergeCommon {
    private static final Logger LOGGER = Logger.getLogger(MergeRemoveValue.class.getName());

    MergeRemoveValue() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Remove existing values");
        LOGGER.info("Testing RFC 7396: Remove existing values");
        this.testStringOnEmptyObject(result);
        this.testStringOnsimpleObject(result);
        this.testIntOnEmptyObject(result);
        this.testIntOnsimpleObject(result);
        this.testBoolOnEmptyObject(result);
        this.testBoolOnsimpleObject(result);
        this.testObjectOnEmptyObject(result);
        this.testObjectOnsimpleObject(result);
        return result;
    }

    private void testStringOnEmptyObject(TestResult result) {
        LOGGER.info(" - for String to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject patch = SimpleValues.createPatchRemoveStr();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testStringOnsimpleObject(TestResult result) {
        LOGGER.info(" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithStr();
        JsonObject patch = SimpleValues.createPatchRemoveStr();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnEmptyObject(TestResult result) {
        LOGGER.info(" - for int to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject patch = SimpleValues.createPatchRemoveInt();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnsimpleObject(TestResult result) {
        LOGGER.info(" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithInt();
        JsonObject patch = SimpleValues.createPatchRemoveInt();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnEmptyObject(TestResult result) {
        LOGGER.info(" - for boolean to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject patch = SimpleValues.createPatchRemoveBool();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnsimpleObject(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithBool();
        JsonObject patch = SimpleValues.createPatchRemoveBool();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnEmptyObject(TestResult result) {
        LOGGER.info(" - for JsonObject to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectObject();
        JsonObject patch = SimpleValues.createPatchRemoveObject();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnsimpleObject(TestResult result) {
        LOGGER.info(" - for JsonObject on compoubnd JSON object");
        JsonObject in = SimpleValues.createCompoundObjectWithObject();
        JsonObject patch = SimpleValues.createPatchRemoveObject();
        JsonObject check = SimpleValues.createCompoundObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }
}

