/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util;

import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class WebUtil {
    public static String getRequestFromURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return url.getFile();
    }

    public static Response sendRequest(String method, InetAddress addr, int port, String req, Properties postData, Hashtable cookieList) throws IOException {
        return WebUtil.sendAuthenticatedRequest(method, addr, port, req, postData, cookieList, null, null);
    }

    public static Response sendAuthenticatedRequest(String method, InetAddress addr, int port, String req, Properties postData, Hashtable cookieList, String username, String password) throws IOException {
        String protocol = "HTTP/1.0";
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        String line = null;
        Response response = new Response();
        String hostname = null;
        try {
            Enumeration keys;
            hostname = addr.getHostName();
            URL requestURL = new URL("http", hostname, port, (String)req);
            req = method + " " + (String)req + " " + protocol;
            socket = new Socket(addr, port);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            WebUtil.send(out, (String)req);
            if (port == 80) {
                WebUtil.send(out, "Host: " + hostname);
            } else {
                WebUtil.send(out, "Host: " + hostname + ":" + port);
            }
            if (cookieList != null && (keys = cookieList.keys()).hasMoreElements()) {
                Object cookieString = "Cookie: ";
                boolean first = true;
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)cookieList.get(key);
                    cookieString = (String)cookieString + (first ? "" : "; ") + key + "=" + value;
                    first = false;
                }
                WebUtil.send(out, (String)cookieString);
            }
            if (username != null) {
                String code = WebUtil.encodeBase64(username + ":" + password);
                WebUtil.send(out, "Authorization: Basic " + code.trim());
            }
            if (postData != null) {
                WebUtil.send(out, "Content-type: application/x-www-form-urlencoded");
            }
            if (postData != null && method.toUpperCase().equals("POST")) {
                String postString = TestUtil.toEncodedString(postData);
                WebUtil.send(out, "Content-length: " + postString.length());
                WebUtil.send(out, "");
                WebUtil.send(out, postString);
            } else {
                WebUtil.send(out, "");
            }
            out.flush();
            line = in.readLine();
            if (line != null) {
                TestUtil.logTrace("HEADER: " + line);
                StringTokenizer st = new StringTokenizer(line.trim());
                response.versionToken = st.nextToken();
                response.statusToken = st.nextToken();
            }
            while ((line = in.readLine()) != null) {
                TestUtil.logTrace("HEADER: " + line);
                if (line.trim().equals("")) break;
                if (line.toLowerCase().startsWith("location:")) {
                    response.location = line.substring(10);
                    continue;
                }
                if (line.toLowerCase().startsWith("set-cookie:")) {
                    response.parseCookie(line);
                    continue;
                }
                if (!line.toLowerCase().startsWith("www-authenticate:")) continue;
                response.authenticationRequested = true;
            }
            while ((line = in.readLine()) != null) {
                response.content = response.content + line + "\n";
            }
            in.close();
            out.close();
        }
        catch (MalformedURLException e) {
            throw new IOException("MalformedURLException: " + e.getMessage());
        }
        catch (UnknownHostException e) {
            throw new IOException("UnknownHostException: " + e.getMessage());
        }
        catch (ConnectException e) {
            throw new IOException("ConnectException: " + e.getMessage());
        }
        return response;
    }

    private static void send(PrintWriter out, String s) {
        out.print(s + "\r\n");
        TestUtil.logTrace("REQUEST: " + s);
    }

    public static String encodeBase64(String s) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encodeBuffer(s.getBytes());
    }

    public static class Response {
        public String versionToken;
        public String statusToken;
        public String location;
        public String content = "";
        public Hashtable cookies = new Hashtable();
        public boolean authenticationRequested = false;

        public void parseCookie(String cookieLine) {
            int semicolon = (cookieLine = cookieLine.substring("Set-Cookie:".length()).trim()).indexOf(";");
            if (semicolon != -1) {
                cookieLine = cookieLine.substring(0, semicolon).trim();
            }
            int equals = cookieLine.indexOf("=");
            String name = cookieLine.substring(0, equals).toUpperCase();
            String value = cookieLine.substring(equals + 1);
            this.cookies.put(name.trim(), value.trim());
        }

        public boolean isError() {
            return this.statusToken.startsWith("4") || this.statusToken.startsWith("5");
        }
    }
}

