/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.ssebroadcaster;

import ee.jakarta.tck.ws.rs.common.util.Holder;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseBroadcaster;
import jakarta.ws.rs.sse.SseEventSink;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@Path(value="broadcast")
public class BroadcastResource {
    private static final List<SseEventSink> sinkList = Collections.synchronizedList(new LinkedList());
    private static volatile Holder<SseBroadcaster> broadcaster = new Holder();
    private static final Holder<SseEventSink> onCloseSink = new Holder();
    private static int cnt;

    @GET
    @Path(value="clear")
    public String clear() {
        sinkList.clear();
        onCloseSink.set(null);
        broadcaster.set(null);
        cnt = 0;
        return "CLEAR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="register")
    @Produces(value={"text/event-stream"})
    public void register(@Context SseEventSink sink, @Context Sse sse) {
        Holder<SseBroadcaster> holder = broadcaster;
        synchronized (holder) {
            if (broadcaster.get() == null) {
                broadcaster.set(sse.newBroadcaster());
            }
            onCloseSink.set(null);
            broadcaster.get().register(sink);
            broadcaster.get().onClose(onCloseSink::set);
            sinkList.add(sink);
        }
        sink.send(sse.newEvent("WELCOME" + cnt++));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="broadcast")
    public String broadcast(@Context Sse sse, String message) {
        Holder<SseBroadcaster> holder = broadcaster;
        synchronized (holder) {
            broadcaster.get().broadcast(sse.newEvent(message));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="close")
    public String close() {
        Holder<SseBroadcaster> holder = broadcaster;
        synchronized (holder) {
            broadcaster.get().close();
        }
        return "CLOSE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="check")
    public String check() {
        StringBuffer sb = new StringBuffer();
        Holder<SseBroadcaster> holder = broadcaster;
        synchronized (holder) {
            Iterator<SseEventSink> si = sinkList.iterator();
            for (int i = 0; i != sinkList.size(); ++i) {
                sb.append("SseEventSink number ").append(i).append(" is closed:").append(si.next().isClosed());
            }
            sb.append("OnCloseSink has been called:").append(onCloseSink.get() != null);
        }
        return sb.toString();
    }
}

