/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.put;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.put.HttpMethodPutTest;
import ee.jakarta.tck.ws.rs.ee.rs.put.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = -71817508809693264L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_put_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/put/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_put_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, HttpMethodPutTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void putTest1() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept:text/plain");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "dummy");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "PutTest"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CTS-put text/plain");
        this.invoke();
    }

    @Test
    public void putTest2() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "dummy");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept:text/html");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "PutTest"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CTS-put text/html");
        this.invoke();
    }

    @Test
    public void putSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "dummy");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.PUT, "PutTest/sub"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "CTS-put text/html");
        this.invoke();
    }
}

