/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import jdk.incubator.http.ExchangeImpl;
import jdk.incubator.http.Http1Exchange;
import jdk.incubator.http.Http2Connection;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.HttpResponseImpl;
import jdk.incubator.http.MultiExchange;
import jdk.incubator.http.PushGroup;
import jdk.incubator.http.Response;
import jdk.incubator.http.Stream;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;

final class Exchange<T> {
    final HttpRequestImpl request;
    final HttpClientImpl client;
    volatile ExchangeImpl<T> exchImpl;
    private volatile IOException failed;
    final List<SocketPermission> permissions = new LinkedList<SocketPermission>();
    final AccessControlContext acc;
    final MultiExchange<?, T> multi;
    final Executor parentExecutor;
    final HttpRequest.BodyProcessor requestProcessor;
    boolean upgrading;
    final PushGroup<?, T> pushGroup;
    static final SocketPermission[] SOCKET_ARRAY = new SocketPermission[0];

    Exchange(HttpRequestImpl httpRequestImpl, MultiExchange<?, T> multiExchange) {
        this.request = httpRequestImpl;
        this.upgrading = false;
        this.client = multiExchange.client();
        this.multi = multiExchange;
        this.acc = multiExchange.acc;
        this.parentExecutor = multiExchange.executor;
        this.requestProcessor = httpRequestImpl.requestProcessor;
        this.pushGroup = multiExchange.pushGroup;
    }

    Exchange(HttpRequestImpl httpRequestImpl, MultiExchange<?, T> multiExchange, AccessControlContext accessControlContext) {
        this.request = httpRequestImpl;
        this.acc = accessControlContext;
        this.upgrading = false;
        this.client = multiExchange.client();
        this.multi = multiExchange;
        this.parentExecutor = multiExchange.executor;
        this.requestProcessor = httpRequestImpl.requestProcessor;
        this.pushGroup = multiExchange.pushGroup;
    }

    PushGroup<?, T> getPushGroup() {
        return this.pushGroup;
    }

    Executor executor() {
        return this.parentExecutor;
    }

    public HttpRequestImpl request() {
        return this.request;
    }

    HttpClientImpl client() {
        return this.client;
    }

    public Response response() throws IOException, InterruptedException {
        return this.responseImpl(null);
    }

    public T readBody(HttpResponse.BodyHandler<T> bodyHandler) throws IOException {
        return this.exchImpl.readBody(bodyHandler, !this.request.isWebSocket());
    }

    public CompletableFuture<T> readBodyAsync(HttpResponse.BodyHandler<T> bodyHandler) {
        return this.exchImpl.readBodyAsync(bodyHandler, !this.request.isWebSocket(), this.parentExecutor);
    }

    public void cancel() {
        if (this.exchImpl != null) {
            this.exchImpl.cancel();
        } else {
            this.cancel(new IOException("Request cancelled"));
        }
    }

    public void cancel(IOException iOException) {
        ExchangeImpl<T> exchangeImpl = this.exchImpl;
        if (exchangeImpl != null) {
            exchangeImpl.cancel(iOException);
        } else {
            try {
                this.failed = iOException;
                this.checkCancelled(false);
            }
            catch (IOException iOException2) {
                throw new UncheckedIOException(iOException2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancelled(boolean bl) throws IOException {
        ExchangeImpl<T> exchangeImpl = null;
        IOException iOException = null;
        if (this.failed != null) {
            Exchange exchange = this;
            synchronized (exchange) {
                iOException = this.failed;
                exchangeImpl = this.exchImpl;
                if (bl || exchangeImpl != null) {
                    this.failed = null;
                }
            }
        }
        if (iOException == null) {
            return;
        }
        if (exchangeImpl != null) {
            exchangeImpl.cancel(iOException);
        } else {
            if (bl) {
                throw iOException;
            }
            Log.logTrace("Exchange: request [{0}/timeout={1}ms] no impl is set.\n\tCan''t cancel yet with {2}", this.request.uri(), this.request.duration() == null ? -1L : this.request.duration().getSeconds() * 1000L + (long)(this.request.duration().getNano() / 1000000), iOException);
        }
    }

    public void h2Upgrade() {
        this.upgrading = true;
        this.request.setH2Upgrade(this.client.client2());
    }

    Response responseImpl(HttpConnection httpConnection) throws IOException, InterruptedException {
        SecurityException securityException = this.securityCheck(this.acc);
        if (securityException != null) {
            throw securityException;
        }
        if (this.permissions.size() > 0) {
            try {
                return AccessController.doPrivileged(() -> this.responseImpl0(httpConnection), null, (Permission[])this.permissions.toArray(SOCKET_ARRAY));
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof PrivilegedActionException) {
                    throwable2 = throwable.getCause();
                }
                if (throwable2 instanceof IOException) {
                    throw (IOException)throwable2;
                }
                throw new RuntimeException(throwable2);
            }
        }
        return this.responseImpl0(httpConnection);
    }

    private void establishExchange(HttpConnection httpConnection) throws IOException, InterruptedException {
        this.checkCancelled(true);
        this.exchImpl = ExchangeImpl.get(this, httpConnection);
        this.checkCancelled(true);
    }

    private Response responseImpl0(HttpConnection httpConnection) throws IOException, InterruptedException {
        this.establishExchange(httpConnection);
        if (this.request.expectContinue()) {
            Log.logTrace("Sending Expect: 100-Continue", new Object[0]);
            this.request.addSystemHeader("Expect", "100-Continue");
            this.exchImpl.sendHeadersOnly();
            Log.logTrace("Waiting for 407-Expectation-Failed or 100-Continue", new Object[0]);
            Response response = this.exchImpl.getResponse();
            HttpResponseImpl.logResponse(response);
            int n = response.statusCode();
            if (n != 100) {
                Log.logTrace("Expectation failed: Received {0}", n);
                if (this.upgrading && n == 101) {
                    throw new IOException("Unable to handle 101 while waiting for 100-Continue");
                }
                return response;
            }
            Log.logTrace("Received 100-Continue: sending body", new Object[0]);
            this.exchImpl.sendBody();
            Log.logTrace("Body sent: waiting for response", new Object[0]);
            response = this.exchImpl.getResponse();
            HttpResponseImpl.logResponse(response);
            return this.checkForUpgrade(response, this.exchImpl);
        }
        this.exchImpl.sendHeadersOnly();
        this.exchImpl.sendBody();
        Response response = this.exchImpl.getResponse();
        HttpResponseImpl.logResponse(response);
        return this.checkForUpgrade(response, this.exchImpl);
    }

    public CompletableFuture<Response> responseAsync() {
        return this.responseAsyncImpl(null);
    }

    CompletableFuture<Response> responseAsyncImpl(HttpConnection httpConnection) {
        SecurityException securityException = this.securityCheck(this.acc);
        if (securityException != null) {
            return MinimalFuture.failedFuture(securityException);
        }
        if (this.permissions.size() > 0) {
            return AccessController.doPrivileged(() -> this.responseAsyncImpl0(httpConnection), null, (Permission[])this.permissions.toArray(SOCKET_ARRAY));
        }
        return this.responseAsyncImpl0(httpConnection);
    }

    CompletableFuture<Response> responseAsyncImpl0(HttpConnection httpConnection) {
        try {
            this.establishExchange(httpConnection);
        }
        catch (IOException | InterruptedException exception) {
            return MinimalFuture.failedFuture(exception);
        }
        if (this.request.expectContinue()) {
            this.request.addSystemHeader("Expect", "100-Continue");
            Log.logTrace("Sending Expect: 100-Continue", new Object[0]);
            return ((CompletableFuture)this.exchImpl.sendHeadersAsync().thenCompose(exchangeImpl -> this.exchImpl.getResponseAsync(this.parentExecutor))).thenCompose(response -> {
                HttpResponseImpl.logResponse(response);
                int n = response.statusCode();
                if (n == 100) {
                    Log.logTrace("Received 100-Continue: sending body", new Object[0]);
                    CompletableFuture<Response> completableFuture = this.exchImpl.sendBodyAsync().thenCompose(exchangeImpl -> exchangeImpl.getResponseAsync(this.parentExecutor));
                    completableFuture = this.wrapForUpgrade(completableFuture);
                    completableFuture = this.wrapForLog(completableFuture);
                    return completableFuture;
                }
                Log.logTrace("Expectation failed: Received {0}", n);
                if (this.upgrading && n == 101) {
                    IOException iOException = new IOException("Unable to handle 101 while waiting for 100");
                    return MinimalFuture.failedFuture(iOException);
                }
                return this.exchImpl.readBodyAsync(this::ignoreBody, false, this.parentExecutor).thenApply(object -> response);
            });
        }
        CompletableFuture<Response> completableFuture = ((CompletableFuture)this.exchImpl.sendHeadersAsync().thenCompose(ExchangeImpl::sendBodyAsync)).thenCompose(exchangeImpl -> exchangeImpl.getResponseAsync(this.parentExecutor));
        completableFuture = this.wrapForUpgrade(completableFuture);
        completableFuture = this.wrapForLog(completableFuture);
        return completableFuture;
    }

    private CompletableFuture<Response> wrapForUpgrade(CompletableFuture<Response> completableFuture) {
        if (this.upgrading) {
            return completableFuture.thenCompose(response -> this.checkForUpgradeAsync((Response)response, this.exchImpl));
        }
        return completableFuture;
    }

    private CompletableFuture<Response> wrapForLog(CompletableFuture<Response> completableFuture) {
        if (Log.requests()) {
            return completableFuture.thenApply(response -> {
                HttpResponseImpl.logResponse(response);
                return response;
            });
        }
        return completableFuture;
    }

    HttpResponse.BodyProcessor<T> ignoreBody(int n, HttpHeaders httpHeaders) {
        return HttpResponse.BodyProcessor.discard(null);
    }

    private CompletableFuture<Response> checkForUpgradeAsync(Response response, ExchangeImpl<T> exchangeImpl) {
        int n = response.statusCode();
        if (this.upgrading && n == 101) {
            Http1Exchange http1Exchange = (Http1Exchange)exchangeImpl;
            return http1Exchange.readBodyAsync(this::ignoreBody, false, this.parentExecutor).thenCompose(object -> Http2Connection.createAsync(http1Exchange.connection(), this.client.client2(), this, http1Exchange.getBuffer()).thenCompose(http2Connection -> {
                http2Connection.putConnection();
                Stream stream = http2Connection.getStream(1);
                this.exchImpl = stream;
                return stream.getResponseAsync(null);
            }));
        }
        return MinimalFuture.completedFuture(response);
    }

    private Response checkForUpgrade(Response response, ExchangeImpl<T> exchangeImpl) throws IOException, InterruptedException {
        int n = response.statusCode();
        if (this.upgrading && n == 101) {
            Http1Exchange http1Exchange = (Http1Exchange)exchangeImpl;
            http1Exchange.readBody(this::ignoreBody, false);
            Http2Connection http2Connection = new Http2Connection(http1Exchange.connection(), this.client.client2(), this, http1Exchange.getBuffer());
            http2Connection.putConnection();
            Stream stream = http2Connection.getStream(1);
            this.exchImpl = stream;
            Response response2 = stream.getResponse();
            HttpResponseImpl.logResponse(response2);
            return response2;
        }
        return response;
    }

    private URI getURIForSecurityCheck() {
        URI uRI;
        String string = this.request.method();
        InetSocketAddress inetSocketAddress = this.request.authority();
        URI uRI2 = this.request.uri();
        if (string.equalsIgnoreCase("CONNECT")) {
            try {
                uRI = new URI("socket", null, inetSocketAddress.getHostString(), inetSocketAddress.getPort(), null, null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InternalError(uRISyntaxException);
            }
        } else {
            uRI = uRI2;
        }
        return uRI;
    }

    private SecurityException securityCheck(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        String string = this.request.method();
        HttpHeaders httpHeaders = this.request.getUserHeaders();
        URI uRI = this.getURIForSecurityCheck();
        URLPermission uRLPermission = Utils.getPermission(uRI, string, httpHeaders.map());
        try {
            assert (accessControlContext != null);
            securityManager.checkPermission(uRLPermission, accessControlContext);
            this.permissions.add(Exchange.getSocketPermissionFor(uRI));
        }
        catch (SecurityException securityException) {
            return securityException;
        }
        ProxySelector proxySelector = this.client.proxy().orElse(null);
        if (proxySelector != null) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxySelector.select(uRI).get(0).address();
            if (!string.equals("CONNECT")) {
                try {
                    uRI = new URI("socket", null, inetSocketAddress.getHostString(), inetSocketAddress.getPort(), null, null, null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new InternalError(uRISyntaxException);
                }
                uRLPermission = new URLPermission(uRI.toString(), "CONNECT");
                try {
                    securityManager.checkPermission(uRLPermission, accessControlContext);
                }
                catch (SecurityException securityException) {
                    this.permissions.clear();
                    return securityException;
                }
                String string2 = inetSocketAddress.getHostString() + ":" + Integer.toString(inetSocketAddress.getPort());
                this.permissions.add(new SocketPermission(string2, "connect,resolve"));
            }
        }
        return null;
    }

    HttpClient.Redirect followRedirects() {
        return this.client.followRedirects();
    }

    HttpClient.Version version() {
        return this.multi.version();
    }

    private static SocketPermission getSocketPermissionFor(URI uRI) {
        String string;
        if (System.getSecurityManager() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = uRI.getHost();
        stringBuilder.append(string2);
        int n = uRI.getPort();
        if (n == -1) {
            string = uRI.getScheme();
            if ("http".equals(string)) {
                stringBuilder.append(":80");
            } else {
                stringBuilder.append(":443");
            }
        } else {
            stringBuilder.append(':').append(Integer.toString(n));
        }
        string = stringBuilder.toString();
        return new SocketPermission(string, "connect");
    }

    AccessControlContext getAccessControlContext() {
        return this.acc;
    }
}

