/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class MTL {
    private final File mtl;
    private HashMap<String, ArrayList<String>> table;

    MTL(File mtlFile) {
        this.mtl = mtlFile;
    }

    private void init() {
        if (this.table == null) {
            this.table = new HashMap();
            BufferedReader r = null;
            try {
                String line;
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.mtl), StandardCharsets.UTF_8));
                while ((line = r.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    ArrayList<String> cases = new ArrayList<String>();
                    String testName = null;
                    if (st.hasMoreTokens()) {
                        testName = st.nextToken();
                    }
                    while (st.hasMoreTokens()) {
                        cases.add(st.nextToken());
                    }
                    if (testName == null) continue;
                    this.table.put(testName, cases);
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    List<String> getTestCases(String name) {
        this.init();
        return this.table.get(name);
    }
}

