/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.RowContainer;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableCaptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableSectionElement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=HtmlTable.class)
public class HTMLTableElement
extends RowContainer {
    private HTMLCollection tBodies_;

    @JsxGetter
    public Object getCaption() {
        List captions = this.getDomNodeOrDie().getHtmlElementsByTagName("caption");
        if (captions.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(captions.get(0));
    }

    @JsxSetter
    public void setCaption(Object o) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SET_CAPTION_ALTHOUGH_ALREADY_SET_THROWS_ERROR)) {
            throw Context.reportRuntimeError((String)"Can't set caption");
        }
        if (!(o instanceof HTMLTableCaptionElement)) {
            throw Context.reportRuntimeError((String)"Not a caption");
        }
        this.deleteCaption();
        HTMLTableCaptionElement caption = (HTMLTableCaptionElement)o;
        this.getDomNodeOrDie().appendChild(caption.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTFoot() {
        List tfoots = this.getDomNodeOrDie().getHtmlElementsByTagName("tfoot");
        if (tfoots.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(tfoots.get(0));
    }

    @JsxSetter
    public void setTFoot(Object o) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SET_TFOOT_ALTHOUGH_ALREADY_SET_THROWS_ERROR)) {
            throw Context.reportRuntimeError((String)"Can't set tFoot");
        }
        if (!(o instanceof HTMLTableSectionElement) || !"TFOOT".equals(((HTMLTableSectionElement)o).getTagName())) {
            throw Context.reportRuntimeError((String)"Not a tFoot");
        }
        this.deleteTFoot();
        HTMLTableSectionElement tfoot = (HTMLTableSectionElement)o;
        this.getDomNodeOrDie().appendChild(tfoot.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTHead() {
        List theads = this.getDomNodeOrDie().getHtmlElementsByTagName("thead");
        if (theads.isEmpty()) {
            return null;
        }
        return this.getScriptableFor(theads.get(0));
    }

    @JsxSetter
    public void setTHead(Object o) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_SET_THEAD_ALTHOUGH_ALREADY_SET_THROWS_ERROR)) {
            throw Context.reportRuntimeError((String)"Can't set tHead");
        }
        if (!(o instanceof HTMLTableSectionElement) || !"THEAD".equals(((HTMLTableSectionElement)o).getTagName())) {
            throw Context.reportRuntimeError((String)"Not a tHead");
        }
        this.deleteTHead();
        HTMLTableSectionElement thead = (HTMLTableSectionElement)o;
        this.getDomNodeOrDie().appendChild(thead.getDomNodeOrDie());
    }

    @JsxGetter
    public Object getTBodies() {
        if (this.tBodies_ == null) {
            final HtmlTable table = (HtmlTable)this.getDomNodeOrDie();
            this.tBodies_ = new HTMLCollection(table, false, "HTMLTableElement.tBodies"){

                @Override
                protected List<Object> computeElements() {
                    return new ArrayList<Object>(table.getBodies());
                }
            };
        }
        return this.tBodies_;
    }

    @JsxFunction
    public Object createCaption() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("caption"));
    }

    @JsxFunction
    public Object createTFoot() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("tfoot"));
    }

    @JsxFunction
    public Object createTHead() {
        return this.getScriptableFor(this.getDomNodeOrDie().appendChildIfNoneExists("thead"));
    }

    @JsxFunction
    public void deleteCaption() {
        this.getDomNodeOrDie().removeChild("caption", 0);
    }

    @JsxFunction
    public void deleteTFoot() {
        this.getDomNodeOrDie().removeChild("tfoot", 0);
    }

    @JsxFunction
    public void deleteTHead() {
        this.getDomNodeOrDie().removeChild("thead", 0);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public void refresh() {
    }

    @Override
    protected boolean isContainedRow(HtmlTableRow row) {
        DomNode parent = row.getParentNode();
        return parent != null && parent.getParentNode() == this.getDomNodeOrDie();
    }

    @Override
    public Object insertRow(int index) {
        List<?> rowContainers = this.getDomNodeOrDie().getByXPath("//tbody | //thead | //tfoot");
        if (rowContainers.isEmpty() || index == 0) {
            HtmlElement tBody = this.getDomNodeOrDie().appendChildIfNoneExists("tbody");
            return ((RowContainer)this.getScriptableFor(tBody)).insertRow(0);
        }
        return super.insertRow(index);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getDomNodeOrDie().getAttribute("width");
    }

    @JsxSetter
    public void setWidth(String width) {
        this.getDomNodeOrDie().setAttribute("width", width);
    }

    @JsxGetter
    public String getCellSpacing() {
        return this.getDomNodeOrDie().getAttribute("cellspacing");
    }

    @JsxSetter
    public void setCellSpacing(String cellSpacing) {
        this.getDomNodeOrDie().setAttribute("cellspacing", cellSpacing);
    }

    @JsxGetter
    public String getCellPadding() {
        return this.getDomNodeOrDie().getAttribute("cellpadding");
    }

    @JsxSetter
    public void setCellPadding(String cellPadding) {
        this.getDomNodeOrDie().setAttribute("cellpadding", cellPadding);
    }

    @JsxGetter
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @Override
    @JsxSetter
    public void setInnerHTML(Object value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_READONLY_FOR_SOME_TAGS)) {
            throw Context.reportRuntimeError((String)"innerHTML is read-only for tag 'table'");
        }
        super.setInnerHTML(value);
    }

    @Override
    protected void setInnerTextImpl(String value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_READONLY_FOR_TABLE)) {
            throw Context.reportRuntimeError((String)"innerText is read-only for tag 'table'");
        }
        super.setInnerTextImpl(value);
    }
}

