/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

package com.sun.ts.tests.concurrency.api.ManageableThread;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;

import javax.enterprise.concurrent.ManageableThread;
import javax.enterprise.concurrent.ManagedThreadFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.io.Serializable;
import java.util.Properties;

public class Client extends ServiceEETest implements Serializable {

  public Client() {
  }

  public static void main(String[] args) {
    Client theTests = new Client();
    Status s = theTests.run(args, System.out, System.err);
    s.exit();
  }

  public void setup(String[] args, Properties p) throws Fault {
    TestUtil.logTrace("setup");
    try {
      // do your setup if any here
    } catch (Exception e) {
      TestUtil.logErr("Exception: ", e);
      throw new Fault("Setup failed:", e);
    }
  }

  public void cleanup() throws Fault {
    TestUtil.logTrace("cleanup");
  }

  /*
  * @testName: isShutdown
  * @assertion_ids:  CONCURRENCY:JAVADOC:20;CONCURRENCY:SPEC:99.1;
  * @test_Strategy:  Lookup default ManagedThreadFactory object and create new thread.
  *                  Check return value of method isShutdown of new thread.
  */
  public void isShutdown() throws Fault {
    boolean pass = false;
    try {
      InitialContext ctx = new InitialContext();
      ManagedThreadFactory mtf = (ManagedThreadFactory) ctx.lookup("java:comp/DefaultManagedThreadFactory");
      ManageableThread m = (ManageableThread) mtf.newThread(new TestRunnableWork());
      pass = !m.isShutdown();
    } catch (NamingException ne) {
      TestUtil.logErr("Failed to lookup default ContextService" + ne);
    } catch (Exception e) {
      TestUtil.logErr("Unexpected Exception Caught", e);
    }
    if (!pass)
      throw new Fault("isShutdown failed");
  }
}
