/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.spec.ContextService.contextPropagate_servlet;

import com.sun.ts.lib.util.BASE64Decoder;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

@WebServlet("/TestServlet")
public class TestServlet extends HttpServlet {

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    BASE64Decoder decoder = new BASE64Decoder();
    byte[] proxyAsBytes = decoder.decodeBuffer(req.getParameter("proxy"));
    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(proxyAsBytes));
    try {
      Object proxy = in.readObject();
      resp.getWriter().write(((TestWorkInterface) proxy).doSomeWork());
    } catch (Exception e) {
      throw new ServletException(e);
    }
  }
}
