/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClickableElement
extends StyledElement {
    private final transient Log mainLog_ = LogFactory.getLog(this.getClass());

    protected ClickableElement(String namespaceURI, String qualifiedName, Page page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public Page click() throws IOException {
        return this.click(false, false, false);
    }

    public Page click(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        MouseEvent event = new MouseEvent((DomNode)this, "click", shiftKey, ctrlKey, altKey, 0);
        return this.click(event);
    }

    public Page click(Event event) throws IOException {
        ScriptResult scriptResult;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        SgmlPage page = this.getPage();
        boolean stateUpdated = false;
        if (this.isStateUpdateFirst()) {
            this.doClickAction(page);
            stateUpdated = true;
        }
        Page currentPage = (scriptResult = this.fireEvent(event)) == null ? page : scriptResult.getNewPage();
        if (stateUpdated || ScriptResult.isFalse(scriptResult) || event.isPreventDefault()) {
            return currentPage;
        }
        return this.doClickAction(currentPage);
    }

    public Page dblClick() throws IOException {
        return this.dblClick(false, false, false);
    }

    public Page dblClick(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        Page clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (this.mainLog_.isDebugEnabled()) {
                this.mainLog_.debug((Object)"dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        MouseEvent event = new MouseEvent((DomNode)this, "dblclick", shiftKey, ctrlKey, altKey, 0);
        ScriptResult scriptResult = this.fireEvent(event);
        if (scriptResult == null) {
            return clickPage;
        }
        return scriptResult.getNewPage();
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        return defaultPage;
    }

    public final String getLangAttribute() {
        return this.getAttributeValue("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttributeValue("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeValue("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeValue("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeValue("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeValue("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeValue("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeValue("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeValue("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeValue("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeValue("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeValue("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeValue("onkeyup");
    }

    protected boolean isStateUpdateFirst() {
        return false;
    }
}

