/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.props;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.ant.props.RegexBasedEvaluator;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class ConditionTypeEvaluator
extends RegexBasedEvaluator {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern EQ = Pattern.compile("=");
    private static final String ASSIGN_ATTR = "(?:.+?)=(?:.+?)";
    private static final String PATTERN = "^(!)?(.+?)\\(((?:(?:.+?)=(?:.+?))(?:,(?:.+?)=(?:.+?))*)\\)$";
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$condition$Condition;

    public ConditionTypeEvaluator() {
        super(PATTERN);
    }

    protected Object evaluate(String[] groups, PropertyHelper propertyHelper) {
        Condition cond;
        Project p = propertyHelper.getProject();
        boolean negate = false;
        if ("!".equals(groups[1])) {
            negate = true;
        }
        if ((cond = this.createCondition(p, groups[2])) != null) {
            if (groups[3].length() > 0) {
                Condition realObject;
                Object object = realObject = TypeAdapter.class.isInstance(cond) ? ((TypeAdapter)cond).getProxy() : cond;
                if (realObject == null) {
                    throw new IllegalStateException("Found null proxy object for adapted condition " + cond.toString());
                }
                IntrospectionHelper ih = IntrospectionHelper.getHelper(realObject.getClass());
                String[] attributes = COMMA.split(groups[3]);
                for (int i = 0; i < attributes.length; ++i) {
                    String[] keyValue = EQ.split(attributes[i]);
                    ih.setAttribute(p, (Object)realObject, keyValue[0].trim(), keyValue[1].trim());
                }
            }
            return cond.eval() ^ negate;
        }
        return null;
    }

    private Condition createCondition(Project project, String type) {
        Condition result = null;
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper((Project)project);
        Object o = componentHelper.createComponent(type);
        if (o instanceof Condition) {
            result = (Condition)o;
        } else {
            List restrictedDefinitions = componentHelper.getRestrictedDefinitions(type);
            Iterator iter = restrictedDefinitions.iterator();
            while (iter.hasNext()) {
                AntTypeDefinition typeDefinition = (AntTypeDefinition)iter.next();
                Class exposedClass = typeDefinition.getExposedClass(project);
                if (exposedClass == null || !(class$org$apache$tools$ant$taskdefs$condition$Condition == null ? ConditionTypeEvaluator.class$("org.apache.tools.ant.taskdefs.condition.Condition") : class$org$apache$tools$ant$taskdefs$condition$Condition).isAssignableFrom(exposedClass)) continue;
                try {
                    result = (Condition)typeDefinition.create(project);
                    break;
                }
                catch (Exception e) {
                    project.log("Exception creating type " + typeDefinition, (Throwable)e, 1);
                }
            }
        }
        return result;
    }
}

