/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.mrep.FilesPane;
import com.sun.javatest.mrep.OptionsPane;
import com.sun.javatest.mrep.ReportTool;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

class OptionsDialog
extends ToolDialog {
    private ReportTool tool;
    private ActionListener okListener;
    private JPanel body;
    private Desktop desktop;
    private JPanel[] panes;

    OptionsDialog(final ReportTool tool, ActionListener okListener, UIFactory uif, Desktop desktop) {
        super(tool, uif, "opts");
        this.tool = tool;
        this.okListener = okListener;
        this.desktop = desktop;
        this.setComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                tool.updateGUI();
            }
        });
        this.setHelp("report.options.csh");
    }

    String getResultPath() {
        return ((FilesPane)this.panes[0]).getResultDir();
    }

    String[] getXmlFiles() {
        return ((FilesPane)this.panes[0]).getXmlFiles();
    }

    boolean handleAsConflict() {
        return true;
    }

    boolean resolveByRecent() {
        return ((OptionsPane)this.panes[1]).resolveByRecent();
    }

    boolean isXmlReport() {
        return ((OptionsPane)this.panes[1]).isXmlReport();
    }

    CustomReport[] getCustomReports() {
        return ((OptionsPane)this.panes[1]).getCustomSelected();
    }

    void updateCustomReports() {
    }

    private void setButtonsSize() {
        int i;
        JButton[] bb = ((OptionsPane)this.panes[1]).getButtons();
        JButton[] fb = ((FilesPane)this.panes[0]).getButtons();
        JButton[] all = new JButton[bb.length + fb.length];
        int max = 0;
        for (i = 0; i < all.length; ++i) {
            all[i] = i < bb.length ? bb[i] : fb[i - bb.length];
            max = max > all[i].getMinimumSize().width ? max : all[i].getMinimumSize().width;
        }
        for (i = 0; i < all.length; ++i) {
            all[i].setPreferredSize(new Dimension(max, all[i].getPreferredSize().height));
            all[i].setMinimumSize(all[i].getPreferredSize());
        }
    }

    @Override
    protected void windowClosingAction(AWTEvent e) {
        this.cleanUp();
    }

    @Override
    protected void initGUI() {
        this.setI18NTitle("opts.title");
        JPanel tabs = new JPanel();
        CardLayout cl = new CardLayout();
        tabs.setLayout(cl);
        this.panes = new JPanel[]{new FilesPane(this.uif, new ChangeTabListener(cl, "1", tabs)), new OptionsPane(this.uif, this.desktop, new ChangeTabListener(cl, "0", tabs), this.okListener)};
        this.attachYardKeeper(((FilesPane)this.panes[0]).getButtons()[1]);
        this.attachYardKeeper(((OptionsPane)this.panes[1]).getButtons()[1]);
        this.attachYardKeeper(((OptionsPane)this.panes[1]).getButtons()[2]);
        this.body = this.uif.createPanel("opts.fields", new BorderLayout(), false);
        for (int i = 0; i < this.panes.length; ++i) {
            tabs.add((Component)this.panes[i], "" + i);
        }
        this.body.add(tabs);
        this.setBody(this.body);
        this.setButtonsSize();
        this.pack();
    }

    private void attachYardKeeper(JButton btn) {
        ActionListener[] listeners = btn.getActionListeners();
        if (listeners.length == 0) {
            btn.addActionListener(new YardKeeper(null));
        } else {
            ActionListener last = listeners[listeners.length - 1];
            btn.removeActionListener(last);
            btn.addActionListener(new YardKeeper(last));
        }
    }

    protected void updateGUI() {
        this.setButtonsSize();
    }

    boolean checkInput() {
        return ((FilesPane)this.panes[0]).checkInput();
    }

    public void cleanUp() {
        this.setBody(null);
    }

    private class YardKeeper
    implements ActionListener {
        private ActionListener chain;

        private YardKeeper(ActionListener chain) {
            this.chain = chain;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.chain != null) {
                this.chain.actionPerformed(e);
            }
        }
    }

    class ChangeTabListener
    implements ActionListener {
        String key;
        CardLayout cl;
        Container parent;

        ChangeTabListener(CardLayout cl, String key, Container parent) {
            this.key = key;
            this.cl = cl;
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cl.show(this.parent, this.key);
        }
    }
}

