/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TSJMSObjects.java 62564 2011-04-18 20:29:25Z kgrucci $
 */

package com.sun.ts.lib.porting;

import com.sun.ts.lib.util.*;

/**
 * This is a factory class for creating instances of TSJMSObjectsInterface.
 * The implementation classes used are determined by the values of the
 * porting package properties in TS_HOME/bin/ts.jte.
 *
 */
public class TSJMSObjects { 

    private static final String DEFAULT_PORTING_CLASS
        = "com.sun.ts.lib.implementation.sun.jms.SunRIJMSObjects";

    private static String portingPropName = "porting.ts.jmsObjects.class.1";

    private static String portingClass = null;

    private static TSJMSObjectsInterface tsJmsObjects = null;

    public static TSJMSObjectsInterface getJMSObjectsInstance() 
               throws Exception {
        try {
            // Create instance of the TSJMSObjectsInterface implementation 
            // class
            TestUtil.logMsg("TSJMSObjects.getJMSObjectsInstance()");
            portingClass = TestUtil.getProperty(portingPropName);
            if (portingClass == null) {
                portingClass = DEFAULT_PORTING_CLASS;
                TestUtil.logMsg("Property " + portingPropName + " not set. " +
                                "Using default porting class. " );
            }
            TestUtil.logMsg("Porting implementation class=" + portingClass);
            if(tsJmsObjects == null) {
                Class c = Class.forName(portingClass);
                tsJmsObjects = (TSJMSObjectsInterface)c.newInstance();
            }
            return tsJmsObjects;
        } catch(Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

