/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeBodyPart;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setContentLanguage()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Set the Content-Language header of MimePart. <p>
 * api2test: public void setContentLanguage(String[])  <p>
 *
 * how2test: Call API with array of String, then do getContentLanguage(),
 *	     call if set/get values match then testcase passes.
 */

public class setContentLanguage_Test extends MailTest {

    public static String[] setlang = {"us-english","uk-english","in-punjabi","en", "fr", "de"};

    public static void main( String argv[] )
    {
        setContentLanguage_Test test = new setContentLanguage_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class MimeBodyPart: setContentLanguage(String[])\n");

        try {
          // Create a MimeBodyPart object
	     MimeBodyPart bp = new MimeBodyPart();

             if( bp == null )
                 return Status.failed("Failed to create MimeBodyPart object!");

	  // BEGIN UNIT TEST:
	     bp.setContentLanguage(setlang); 	// API TEST
	     String[] getlang = bp.getContentLanguage();

	     for( int i = 0; i < getlang.length; i++ )
	     {
		  out.println("UNIT TEST "+i+": setContentLanguage("+setlang[i]+")");

		  if( setlang[i].equals(getlang[i]) )
	              out.println("UNIT TEST "+i+":  passed.\n");
	          else {
		        out.println("UNIT TEST "+i+":  FAILED.\n");
			errors++;
		  }
	     }
	  // END UNIT TEST:
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
