/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.NonSerializable;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLCollection
extends SimpleScriptable
implements Function,
NodeList {
    private static final long serialVersionUID = 4049916048017011764L;
    private String xpath_;
    private DomNode node_;
    private boolean avoidObjectDetection_ = false;
    private Transformer transformer_;
    private List<Object> cachedElements_;

    @Deprecated
    public HTMLCollection() {
    }

    public HTMLCollection(DomNode parentScope) {
        this(parentScope.getScriptObject());
    }

    public HTMLCollection(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public void init(DomNode node, String xpath) {
        this.init(node, xpath, NOPTransformer.INSTANCE);
    }

    public void init(DomNode node, String xpath, Transformer transformer) {
        if (node != null) {
            this.node_ = node;
            this.xpath_ = xpath;
            this.transformer_ = transformer;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    public void initFromChildren(DomNode node) {
        if (node != null) {
            this.node_ = node;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
        this.transformer_ = NOPTransformer.INSTANCE;
    }

    public final Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        return this.nullIfNotFound(this.get(args[0]));
    }

    public final Scriptable construct(Context arg0, Scriptable arg1, Object[] arg2) throws JavaScriptException {
        return null;
    }

    private Object get(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        HTMLCollection array = (HTMLCollection)start;
        List<Object> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableFor(this.transformer_.transform(elements.get(index)));
        }
        return NOT_FOUND;
    }

    protected List<Object> getElements() {
        if (this.cachedElements_ == null) {
            this.cachedElements_ = this.computeElements();
        }
        return this.cachedElements_;
    }

    protected List<Object> computeElements() {
        List<Object> response;
        if (this.node_ != null) {
            if (this.xpath_ != null) {
                response = XPathUtils.getByXPath(this.node_, this.xpath_);
            } else {
                response = new ArrayList();
                for (Node node = this.node_.getFirstChild(); node != null; node = node.getNextSibling()) {
                    response.add(node);
                }
            }
        } else {
            response = new ArrayList();
        }
        boolean isXmlPage = this.node_ != null && this.node_.getOwnerDocument() instanceof XmlPage;
        boolean isIE = this.getBrowserVersion().isIE();
        block1: for (int i = 0; i < response.size(); ++i) {
            Boolean xmlSpaceDefault;
            DomNode element = (DomNode)response.get(i);
            if (isIE && isXmlPage && element instanceof DomText && ((DomText)element).getNodeValue().trim().length() == 0 && (xmlSpaceDefault = HTMLCollection.isXMLSpaceDefault(element.getParentNode())) != Boolean.FALSE) {
                response.remove(i--);
                continue;
            }
            for (DomNode parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof HtmlNoScript)) continue;
                response.remove(i--);
                continue block1;
            }
        }
        return response;
    }

    private static Boolean isXMLSpaceDefault(DomNode node) {
        while (node instanceof XmlElement) {
            String value = ((XmlElement)node).getAttributeValue("xml:space");
            if (value.length() != 0) {
                if (value.equals("default")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            node = node.getParentNode();
        }
        return null;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if (this.xpath_ == null || "length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        CollectionUtils.transform(elements, (Transformer)this.transformer_);
        for (Object next : elements) {
            if (next instanceof HtmlElement || next instanceof XmlElement) {
                String id = next instanceof HtmlElement ? ((HtmlElement)next).getId() : ((XmlElement)next).getAttributeValue("id");
                if (id == null || !id.equals(name)) continue;
                this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by id) to " + next));
                return this.getScriptableFor(next);
            }
            if (next instanceof WebWindow) {
                WebWindow window = (WebWindow)next;
                String windowName = window.getName();
                if (windowName == null || !windowName.equals(name)) continue;
                this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + window));
                return this.getScriptableFor(window);
            }
            this.getLog().warn((Object)("Unrecognized type in collection: " + next + " (" + next.getClass().getName() + ")"));
        }
        HTMLCollection array = new HTMLCollection(this);
        String newCondition = "@name = '" + name + "'";
        String currentXPathExpr = this.xpath_.toString();
        String xpathExpr = currentXPathExpr.endsWith("]") ? currentXPathExpr.substring(0, currentXPathExpr.length() - 1) + " and " + newCondition + "]" : currentXPathExpr + "[" + newCondition + "]";
        array.init(this.node_, xpathExpr);
        List<Object> subElements = array.getElements();
        if (subElements.size() > 1) {
            this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + array + " with " + subElements.size() + " elements"));
            return array;
        }
        if (subElements.size() == 1) {
            SimpleScriptable singleResult = this.getScriptableFor(subElements.get(0));
            this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + (Object)((Object)singleResult)));
            return singleResult;
        }
        return NOT_FOUND;
    }

    public final int jsxGet_length() {
        return this.getElements().size();
    }

    public final Object jsxFunction_item(Object index) {
        return this.nullIfNotFound(this.get(index));
    }

    private Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    public final Object jsxFunction_namedItem(String name) {
        return this.nullIfNotFound(this.get(name));
    }

    public Object jsxFunction_tags(String tagName) {
        HTMLCollection array = new HTMLCollection(this);
        array.init(this.node_, this.xpath_ + "[name() = '" + tagName.toLowerCase() + "']");
        return array;
    }

    public String toString() {
        if (this.xpath_ != null) {
            return super.toString() + '<' + this.xpath_ + '>';
        }
        return super.toString();
    }

    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof HTMLCollection) {
            HTMLCollection otherArray = (HTMLCollection)other;
            if (this.node_ == otherArray.node_ && this.xpath_.toString().equals(otherArray.xpath_.toString()) && this.transformer_.equals(otherArray.transformer_)) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    public boolean has(String name, Scriptable start) {
        try {
            int index = Integer.parseInt(name);
            List<Object> elements = this.getElements();
            CollectionUtils.transform(elements, (Transformer)this.transformer_);
            if (index >= 0 && index < elements.size()) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (name.equals("length")) {
            return true;
        }
        if (!this.getBrowserVersion().isIE()) {
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_2);
            for (String functionName : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                if (!name.equals(functionName)) continue;
                return true;
            }
            return false;
        }
        return this.getWithPreemption(name) != NOT_FOUND;
    }

    public Object[] getIds() {
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        CollectionUtils.transform(elements, (Transformer)this.transformer_);
        if (!this.getBrowserVersion().isIE()) {
            int length = this.getElements().size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_2);
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                idList.add(name);
            }
        } else {
            idList.add("length");
            int index = 0;
            for (Object next : elements) {
                if (next instanceof HtmlElement) {
                    HtmlElement element = (HtmlElement)next;
                    String name = element.getAttribute("name");
                    if (name != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
                        idList.add(name);
                    } else {
                        String id = element.getId();
                        if (id != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
                            idList.add(id);
                        } else {
                            idList.add(Integer.toString(index));
                        }
                    }
                    ++index;
                    continue;
                }
                if (next instanceof WebWindow) {
                    WebWindow window = (WebWindow)next;
                    String windowName = window.getName();
                    if (windowName == null) continue;
                    idList.add(windowName);
                    continue;
                }
                this.getLog().debug((Object)("Unrecognized type in array: \"" + next.getClass().getName() + "\""));
            }
        }
        return idList.toArray();
    }

    @Override
    public int getLength() {
        return this.jsxGet_length();
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.transformer_.transform(this.getElements().get(index));
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener,
    NonSerializable {
        private static final long serialVersionUID = 5296270270141251350L;

        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void nodeDeleted(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }
    }
}

