/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: R1005ConformanceChecker.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1005;

import com.sun.ts.tests.jaxrpc.common.RequestConformanceChecker;

import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.*;
import java.util.Iterator;

public class R1005ConformanceChecker extends RequestConformanceChecker{

    public void test(SOAPMessageContext context) throws SOAPException{
        test(context.getMessage().getSOAPPart().getEnvelope());
    }

    private void test(SOAPElement elem){
        boolean fails = false;
        String namespace = elem.getElementName().getURI();
        if(namespace != null && namespace.equals(SOAP_ENV_NS)){
            fails = hasEncodingStyleAttr(elem);
        }
        if(!fails){
            Iterator children = elem.getChildElements();
            while(children.hasNext()){
                Object o = children.next();
                if (o instanceof SOAPElement) {
                    test((SOAPElement)o);
                }
            }
        }
        else{
            response = "failed. Elements with namespace of http://schemas.xmlsoap.org/soap/envelope/" +
                    "cannot have soap:encodingStyle attribute.";
        }
    }

    private boolean hasEncodingStyleAttr(SOAPElement elem){
        Iterator attrs = elem.getAllAttributes();
        Name name;
        String uri;
        while(attrs.hasNext()){
            name = (Name)attrs.next();
            uri = name.getURI();
            if(uri == null){
                uri = "";
            }
            if(name.getLocalName().equals(SOAP_ENC_STYLE) && uri.equals(SOAP_ENV_NS)){
                return true;
            }
        }
        return false;
    }
}
