/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: R1014ConformanceChecker.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1014;

import com.sun.ts.tests.jaxrpc.common.RequestConformanceChecker;

import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.*;
import java.util.Iterator;

public class R1014ConformanceChecker extends RequestConformanceChecker{

    public void test(SOAPMessageContext context) throws SOAPException{
        SOAPBody body = getBody(context);
        Iterator children = body.getChildElements();
        SOAPElement element;
        String uri;
        while(children.hasNext() && response == null){
            element = (SOAPElement)children.next();
            uri = element.getElementName().getURI();
            if(uri == null || uri.equals("")){
                response = "failed. Children of soap:Body must be qualified";
            }
        }
    }

    private SOAPBody getBody(SOAPMessageContext context) throws SOAPException{
        return context.getMessage().getSOAPPart().getEnvelope().getBody();
    }
}
