/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.Map;
import org.apache.xml.utils.PrefixResolverDefault;
import org.w3c.dom.Node;

final class HtmlUnitPrefixResolver
extends PrefixResolverDefault {
    public HtmlUnitPrefixResolver(Node xpathExpressionContext) {
        super(xpathExpressionContext);
    }

    public String getNamespaceForPrefix(String prefix, Node namespaceContext) {
        String namespace = super.getNamespaceForPrefix(prefix, namespaceContext);
        if (namespace == null) {
            if (namespaceContext instanceof XmlPage) {
                XmlElement documentElement = ((XmlPage)namespaceContext).getDocumentXmlElement();
                if (documentElement != null) {
                    namespace = this.getNamespace(documentElement, prefix);
                }
            } else if (namespaceContext instanceof XmlElement) {
                namespace = this.getNamespace((XmlElement)namespaceContext, prefix);
            }
        }
        return namespace;
    }

    private String getNamespace(XmlElement element, String prefix) {
        Map<String, DomAttr> attributes = element.getAttributesMap();
        for (String name : attributes.keySet()) {
            if (!name.startsWith("xmlns:") || !name.substring("xmlns:".length()).equals(prefix)) continue;
            return attributes.get(name).getValue();
        }
        for (DomNode child : element.getChildren()) {
            String namespace;
            if (!(child instanceof XmlElement) || (namespace = this.getNamespace((XmlElement)child, prefix)) == null) continue;
            return namespace;
        }
        return null;
    }
}

