/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.apicover.markup.Adapter;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefCounter {
    private HashMap<String, ClassDescription> api = new HashMap();
    private MODE mode = MODE.WORST;
    private Erasurator erasurator = new Erasurator();
    private Map<String, ClassDescription> ts = new HashMap<String, ClassDescription>();
    Map<String, Integer> results = new HashMap<String, Integer>();

    public void addClass(ClassDescription cd) {
        ArrayList<MemberDescription> modified = new ArrayList<MemberDescription>();
        boolean hasTracked = false;
        Iterator i = cd.getMembersIterator();
        boolean hasMembers = i.hasNext();
        while (i.hasNext()) {
            MemberDescription md = (MemberDescription)i.next();
            if (md.hasModifier(Adapter.coverIgnore)) {
                i.remove();
                continue;
            }
            hasTracked = true;
            MemberDescription md2 = (MemberDescription)md.clone();
            if (this.mode.equals((Object)MODE.WORST) && !md.getDeclaringClassName().equals(cd.getQualifiedName()) && !md.isFinal()) {
                md2.setDeclaringClass(cd.getQualifiedName());
            }
            i.remove();
            modified.add(md2);
        }
        for (MemberDescription md : modified) {
            cd.add(md);
        }
        if (hasTracked || !hasMembers) {
            this.api.put(cd.getQualifiedName(), cd);
        }
    }

    public void addTSClass(ClassDescription cd, boolean fromAPI) {
        if (fromAPI) {
            this.ts.put(cd.getQualifiedName(), this.erasurator.erasure(cd));
            return;
        }
        String parent = this.findSuper(cd);
        if (parent.equals(cd.getQualifiedName()) && cd.getInterfaces().length == 0) {
            return;
        }
        this.ts.put(cd.getQualifiedName(), this.erasurator.erasure(cd));
    }

    public void addRef(MemberDescription call) {
        Set<Object> calledClasses = Collections.emptySet();
        if (this.ts.get(call.getDeclaringClassName()) == null) {
            return;
        }
        try {
            calledClasses = this.findDecl(this.ts.get(call.getDeclaringClassName()), call);
        }
        catch (Exception e) {
            SwissKnife.reportThrowable(e);
        }
        for (String calledCl : calledClasses) {
            ClassDescription apiClass = this.api.get(calledCl);
            if (apiClass == null) continue;
            this.erasurator.parseTypeParameters(apiClass);
            Iterator j = apiClass.getMembersIterator();
            while (j.hasNext()) {
                MemberDescription orig = (MemberDescription)j.next();
                MemberDescription erased = this.erasurator.processMember(orig);
                if (!erased.equals(call)) continue;
                Integer count = this.results.get(orig.toString());
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                this.results.put(orig.toString(), count);
            }
        }
    }

    private Set<String> findDecl(ClassDescription tsClass, MemberDescription md) {
        boolean foundSuper = true;
        TreeSet<String> result = new TreeSet<String>();
        if (this.mode == MODE.WORST) {
            result.add(tsClass.getQualifiedName());
        }
        while (foundSuper) {
            if (tsClass.getMembersIterator().hasNext()) {
                if (tsClass.containsMember(md)) {
                    String theClass = tsClass.findMember(md).getDeclaringClassName();
                    result.add(theClass);
                    return result;
                }
            } else {
                for (ConstructorDescr constructorDescr : tsClass.getDeclaredConstructors()) {
                    if (!((MemberDescription)constructorDescr).equals(md)) continue;
                    result.add(tsClass.getQualifiedName());
                    return result;
                }
                for (MemberDescription memberDescription : tsClass.getDeclaredFields()) {
                    if (!memberDescription.equals(md)) continue;
                    result.add(tsClass.getQualifiedName());
                    return result;
                }
                for (MemberDescription memberDescription : tsClass.getDeclaredMethods()) {
                    if (!memberDescription.equals(md)) continue;
                    result.add(tsClass.getQualifiedName());
                    return result;
                }
                if (this.mode == MODE.WORST) {
                    result.add(tsClass.getQualifiedName());
                }
            }
            foundSuper = false;
            if (tsClass.getSuperClass() == null || this.ts.get(tsClass.getSuperClass().getQualifiedName()) == null) continue;
            tsClass = this.ts.get(tsClass.getSuperClass().getQualifiedName());
            foundSuper = true;
        }
        return result;
    }

    boolean isCovered(MemberDescription md) {
        return this.results.get(md.toString()) != null;
    }

    int getCoverCount(MemberDescription md) {
        Integer res = this.results.get(md.toString());
        if (res == null) {
            return 0;
        }
        return res;
    }

    private String findSuper(ClassDescription tsClass) {
        while (tsClass.getSuperClass() != null) {
            if (this.ts.get(tsClass.getSuperClass().getQualifiedName()) != null) {
                tsClass = this.ts.get(tsClass.getSuperClass().getQualifiedName());
                continue;
            }
            return tsClass.getQualifiedName();
        }
        return tsClass.getQualifiedName();
    }

    public void setMode(String mode) {
        this.mode = "r".equals(mode) ? MODE.REAL : MODE.WORST;
    }

    private void clearInheretid() {
        for (ClassDescription cd : this.api.values()) {
            Iterator i = cd.getMembersIterator();
            while (i.hasNext()) {
                MemberDescription md = (MemberDescription)i.next();
                if (!(md.isConstructor() || md.isField() || md.isMethod())) {
                    i.remove();
                    continue;
                }
                if (!this.mode.equals((Object)MODE.REAL) || md.getDeclaringClassName().equals(cd.getQualifiedName())) continue;
                i.remove();
            }
        }
    }

    public Collection<ClassDescription> getClasses() {
        this.clearInheretid();
        return this.api.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODE {
        REAL,
        WORST;

    }
}

