/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: SecurityContextImpl.java 69519 2013-01-15 16:58:53Z supol $ 
 */

package com.sun.ts.tests.jaxrs.common.impl;

import java.security.Principal;

import javax.ws.rs.core.SecurityContext;

/**
 * This is simple implementation of a SecurityContext interface
 * There are two constructors, the default representing dummy SecurityContext
 * with no principal, scheme and role, and a constructor with principal scheme
 * and information about whether the connection is secure and whether user is 
 * in role 
 */
public class SecurityContextImpl implements SecurityContext {

	/**
	 * Representation of principal, role, scheme, and secure connection 
	 */
	public SecurityContextImpl(String principal, boolean isUserInRole,
			boolean isSecure, String scheme) {
		super();
		this.principal = principal;
		this.isUserInRole = isUserInRole;
		this.isSecure = isSecure;
		this.scheme = scheme;
	}

	private String principal = null;
	private boolean isUserInRole = false;
	private boolean isSecure = false;
	private String scheme = null;

	/**
	 * Dummy security context
	 */
	public SecurityContextImpl() {
	}

	@Override
	public Principal getUserPrincipal() {
		if (principal == null)
			return null;
		else {
			Principal p = new Principal() {
				@Override
				public String getName() {
					return principal;
				}
			};
			return p;
		}
	}

	@Override
	public boolean isUserInRole(String role) {
		return isUserInRole;
	}

	@Override
	public boolean isSecure() {
		return isSecure;
	}

	@Override
	public String getAuthenticationScheme() { 
		return scheme;
	}

}
