/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringBean.java 69965 2013-02-13 12:02:10Z supol $ 
 */

package com.sun.ts.tests.jaxrs.common.provider;

/**
 * This is the object which standard implementation does not have a provider
 * for, even though its some simple String holder. It can also be used as mutable 
 * string.
 */
public class StringBean {
	private String header;

	public String get() {
		return header;
	}

	public void set(String header) {
		this.header = header;
	}
	
	@Override
	public String toString() {
		return "StringBean. To get a value, use rather #get() method.";
	}

	public StringBean(String header) {
		super();
		this.header = header;
	}
}
