/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PathBeanParamEntity.java 74172 2014-10-30 14:11:06Z supol $ 
 */

package com.sun.ts.tests.jaxrs.ee.rs.beanparam.path.bean;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;

import javax.ws.rs.BeanParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.PathParam;

import com.sun.ts.tests.jaxrs.ee.rs.Constants;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityThrowingWebApplicationException;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityWithConstructor;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityWithFromString;
import com.sun.ts.tests.jaxrs.ee.rs.ParamEntityWithValueOf;

public class PathBeanParamEntity {
	@DefaultValue(Constants.DEFAULT_VALUE)
	@PathParam(Constants.PARAM_ENTITY_WITH_CONSTRUCTOR)
	public ParamEntityWithConstructor paramEntityWithConstructor;

	@Encoded
	@DefaultValue(Constants.DEFAULT_VALUE)
	@PathParam(Constants.PARAM_ENTITY_WITH_FROMSTRING)
	public ParamEntityWithFromString paramEntityWithFromString;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@PathParam(Constants.PARAM_ENTITY_WITH_VALUEOF)
	public ParamEntityWithValueOf paramEntityWithValueOf;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@PathParam(Constants.SET_PARAM_ENTITY_WITH_FROMSTRING)
	public Set<ParamEntityWithFromString> setParamEntityWithFromString;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@PathParam(Constants.SORTED_SET_PARAM_ENTITY_WITH_FROMSTRING)
	public SortedSet<ParamEntityWithFromString> sortedSetParamEntityWithFromString;

	@DefaultValue(Constants.DEFAULT_VALUE)
	@PathParam(Constants.LIST_PARAM_ENTITY_WITH_FROMSTRING)
	public List<ParamEntityWithFromString> listParamEntityWithFromString;

	@PathParam(Constants.ENTITY_THROWING_WEBAPPLICATIONEXCEPTION)
	public ParamEntityThrowingWebApplicationException entityThrowingWebApplicationException;
	
	@PathParam(Constants.ENTITY_THROWING_EXCEPTION_BY_NAME)
	public ParamEntityThrowingExceptionGivenByName entityThrowingExceptionGivenByName;
	
	@BeanParam
	public InnerPathBeanParamEntity inner;
}
