/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ClientSideWriter.java 73547 2014-02-26 20:08:48Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.constrainedto;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@ConstrainedTo(value = RuntimeType.CLIENT)
public class ClientSideWriter implements MessageBodyWriter<String> {

	public static final String FAKE_MESSAGE = "The fake writer on client side";
	public static final MediaType MEDIA_TYPE = new MediaType("writer", "clientside");
	
	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {	
		return mediaType.equals(MEDIA_TYPE);
	}
	@Override
	public long getSize(String t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return FAKE_MESSAGE.length();
	}
	@Override
	public void writeTo(String t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(FAKE_MESSAGE.getBytes(Charset.defaultCharset()));
	}

}
