/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 69513 2013-01-15 12:49:59Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.containerwriter.writerinterceptorcontext;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.ResponseBuilder;

import com.sun.ts.tests.jaxrs.api.rs.ext.interceptor.TemplateInterceptorBody;
import com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.ContextOperation;
import com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.OnWriteExceptionThrowingStringBean;

@Path("resource")
public class Resource {

	@GET
	@Path("{id}")
	public Response genericResponse(@PathParam("id") String path) {
		ContextOperation op = ContextOperation.valueOf(path.toUpperCase());
		ResponseBuilder builder = createResponseBuilderWithHeader(op);
		switch (op) {
		case GETHEADERS:
			for (int i = 0; i != 5; i++)
				builder = builder.header(TemplateInterceptorBody.PROPERTY + i,
						"any");
			break;
		case PROCEEDTHROWSWEBAPPEXCEPTION:
			builder.entity(new OnWriteExceptionThrowingStringBean(
					TemplateInterceptorBody.ENTITY));
			break;
		default:
			break;
		}
		Response response = builder.build();
		return response;
	}

	// ///////////////////////////////////////////////////////////////////////

	static ResponseBuilder createResponseBuilderWithHeader(
			ContextOperation op) {
		Response.ResponseBuilder builder = Response.ok();
		// set a header with ContextOperation so that the filter knows what to
		// do
		builder = builder.header(TemplateInterceptorBody.OPERATION, op.name());
		builder = builder.entity(TemplateInterceptorBody.ENTITY);
		return builder;
	}

}
