/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: LocatorResource.java 71955 2013-05-22 18:30:50Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.formparam.locator;

import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;

@Path("resource")
public class LocatorResource extends MiddleResource {

	@Path("locator/{id1}")
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)	
	public MiddleResource locatorHasArguments(@PathParam("id1") String id1,
			@FormParam("default_argument") String arg) throws Exception {
		return new MiddleResource(id1, arg);
	}
	
	@Path("locatorencoded/{id1}")
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)	
	public MiddleResource locatorHasEncodedArguments(@PathParam("id1") String id1,
			@Encoded @FormParam("default_argument") String arg) throws Exception {
		return new MiddleResource(id1, arg);
	}	
}
