/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PreMatchingThrowingFilter.java 69965 2013-02-13 12:02:10Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.exception;

import java.io.IOException;

import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;

@Priority(50)
@Provider
@PreMatching
public class PreMatchingThrowingFilter implements ContainerRequestFilter {

	public static final String EXCEPTION_FIRING_HEADER = "PreMatchingFilterThrowsException";

	@Override
	public void filter(ContainerRequestContext requestContext)
			throws IOException {
		String header = requestContext.getHeaderString(EXCEPTION_FIRING_HEADER);
		if (header != null)
			throw new RuntimeException(header);
	}

}
