/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: RuntimeExceptionMapper.java 69691 2013-01-30 14:19:01Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.exception;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;


/**
 * Use RuntimeException as WebApplicationException does not have constructor 
 * for message argument and getMessage does not work then 
 */
@Provider
public class RuntimeExceptionMapper implements ExceptionMapper<RuntimeException> {
	
	public static final String THROW_AGAIN = "ThrowExceptionOnceAgain";

	@Override
	public Response toResponse(RuntimeException exception) {
		String message = exception.getMessage();
		//Throw again from this mapper
		if (message.equals(THROW_AGAIN))
			throw new RuntimeException("100000");
		//Throw again from postmatching filter
		if (message.equals(PostMatchingThrowingFilter.EXCEPTION_FIRING_HEADER))
			return Response.ok("100000").header(message, "500").build();
		//Throw again from prematching filter
		if (message.equals(PreMatchingThrowingFilter.EXCEPTION_FIRING_HEADER))
			return Response.ok("100000").header(message, "500").build();
		//Once the exception is thrown, this mapper should not be used to handle it
		//returning status 500
		//Do not throw again
		return Response.ok(message).build();
	}

}
