/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: Resource.java 69662 2013-01-28 19:05:43Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.namebinding;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Path("resource")
public class Resource {

	@SingleNameBinding
	@Path("ten")
	@GET
	public String getTen() {
		return "10";
	}

	@Path("one")
	@GET
	// no NameBinding, no interceptor shall be invoked
	public String getOne() {
		return "1";
	}

	@Path("echo")
	@SingleNameBinding
	@POST
	public String echo(String value) {
		return value;
	}
	
	@Path("complement")
	@GET
	@ComplementNameBinding
	//This has only complement binding, i.e. no interceptor contains only
	//complement binding, i.e. no interceptor shall be called
	public String complement(){
		return "10000";
	}
}
