/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.provider.visibility;

import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;

public class HolderClass {
	public static final String OK = "11111";
	
	private HttpHeaders headers;
	private UriInfo info;
	private Application application;
	private Request request;
	private Providers provider;

	public HolderClass(HttpHeaders headers, UriInfo info,
			Application application, Request request, Providers provider) {
		super();
		this.headers = headers;
		this.info = info;
		this.application = application;
		this.request = request;
		this.provider = provider;
	}

	public Response toResponse(){
		int ok = application != null ? 1 : 0;
		ok += headers != null ? 10 : 0;
		ok += info != null ? 100 : 0;
		ok += request != null ? 1000 : 0;
		ok += provider == null ? 10000 : 0;		
		return Response.ok(String.valueOf(ok)).build();		
	}
}
