/*
 * $Id: JAXRSClient.java 69965 2013-02-13 12:02:10Z supol $
 * 
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jaxrs.spec.provider.visibility;

import javax.ws.rs.core.MediaType;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */

public class JAXRSClient extends JAXRSCommonClient {

	private static final long serialVersionUID = 1L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_spec_provider_visibility_web/resource");
	}

	/**
	 * Entry point for different-VM execution. It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: contextResolverTest
	 * @assertion_ids: JAXRS:SPEC:27; JAXRS:SPEC:28; 
	 * @test_Strategy: Provider classes are instantiated by the JAX-RS runtime 
	 * 					and MUST have a public constructor for which the 
	 * 					JAX-RS runtime can provide all parameter values.
	 * 
	 *  				If more than one public constructor can be used then an 
	 *  				implementation MUST use the one with the most parameters
	 */
	public void contextResolverTest() throws Fault {
		setProperty(Property.REQUEST,
				buildRequest(Request.GET, "contextresolver"));
		setProperty(Property.SEARCH_STRING, HolderClass.OK);
		invoke();
	}

	/*
	 * @testName: exceptionMapperTest
	 * @assertion_ids: JAXRS:SPEC:27; JAXRS:SPEC:28; 
	 * @test_Strategy: Provider classes are instantiated by the JAX-RS runtime 
	 * 					and MUST have a public constructor for which the 
	 * 					JAX-RS runtime can provide all parameter values.
	 * 
	 *  				If more than one public constructor can be used then an 
	 *  				implementation MUST use the one with the most parameters
	 */
	public void exceptionMapperTest() throws Fault {
		setProperty(Property.REQUEST,
				buildRequest(Request.GET, "exceptionmapper"));
		setProperty(Property.SEARCH_STRING, HolderClass.OK);
		invoke();
	}

	/*
	 * @testName: bodyWriterTest
	 * @assertion_ids: JAXRS:SPEC:27; JAXRS:SPEC:28; 
	 * @test_Strategy: Provider classes are instantiated by the JAX-RS runtime 
	 * 					and MUST have a public constructor for which the 
	 * 					JAX-RS runtime can provide all parameter values.
	 * 
	 *  				If more than one public constructor can be used then an 
	 *  				implementation MUST use the one with the most parameters
	 */
	public void bodyWriterTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.GET, "bodywriter"));
		setProperty(Property.SEARCH_STRING, HolderClass.OK);
		invoke();
	}

	/*
	 * @testName: bodyReaderTest
	 * @assertion_ids: JAXRS:SPEC:27; JAXRS:SPEC:28; 
	 * @test_Strategy: Provider classes are instantiated by the JAX-RS runtime 
	 * 					and MUST have a public constructor for which the 
	 * 					JAX-RS runtime can provide all parameter values.
	 * 
	 *  				If more than one public constructor can be used then an 
	 *  				implementation MUST use the one with the most parameters
	 */
	public void bodyReaderTest() throws Fault {
		MediaType type = new MediaType("text", "tck");
		setProperty(Property.REQUEST, buildRequest(Request.POST, "bodyreader"));
		setProperty(Property.CONTENT, "text");
		setProperty(Property.REQUEST_HEADERS, buildContentType(type));
		setProperty(Property.SEARCH_STRING, HolderClass.OK);
		invoke();
	}

}
