/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AppJavaEntityWriter.java 69881 2013-02-07 16:49:08Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.provider.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Produces("application/java")
@Provider
public class AppJavaEntityWriter implements MessageBodyWriter<EntityForWriter> {
	// Do not inherit
	private static boolean isWritable = false;

	public static void setWritable(boolean bool) {
		isWritable = bool;
	}

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		AppXmlObjectWriter.addClass(getClass().getSimpleName());
		return isWritable;
	}

	@Override
	public long getSize(EntityForWriter t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		AppXmlObjectWriter.addClass(getClass().getSimpleName().toUpperCase());
		return AppXmlObjectWriter.writerSet.length();
	}

	@Override
	public void writeTo(EntityForWriter t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		//in case getSize() is not used, 
		//otherwise these additional characters are omitted.		
		getSize(t, type, genericType, annotations, mediaType);		
		entityStream.write(AppXmlObjectWriter.writerSet.toString().getBytes());
	}

}
