package com.sun.ts.tests.jaxrs.spec.returntype;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.UUID;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class UUIDWriter implements MessageBodyWriter<UUID> {

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return type == UUID.class;
	}

	@Override
	public long getSize(UUID t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return 36;
	}

	@Override
	public void writeTo(UUID t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		entityStream.write(t.toString().getBytes());
	}

}
