/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HelloImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.w2j.rpc.literal.httptest;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.jws.WebService;

@WebService(
    portName="HelloPort",
    serviceName="HttpTestService",
    targetNamespace="http://httptestservice.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/WSW2JRLHttpTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.ee.w2j.rpc.literal.httptest.Hello"
)
public class HelloImpl implements Hello {

    public HelloResponse hello(HelloRequest req) {
        System.out.println("Hello, " + req.getString() + "!");
	HelloResponse resp = new HelloResponse();
	resp.setString("Hello, " + req.getString() + "!");
        return resp;
    }

    public void helloOneWay(HelloOneWay req) {
        System.out.println("Hello OneWay, " + req.getString() + "!");
    }
}
