/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: J2WDLSharedEndpointImpl.java 62872 2011-05-25 18:32:38Z adf $
 */

package com.sun.ts.tests.jaxws.mapping.j2wmapping.document.literal.wrapped;

import javax.xml.ws.WebServiceException;

import javax.jws.WebService;

@WebService(
    portName="J2WDLSharedEndpointPort",
    serviceName="J2WDLSharedService",
    targetNamespace="http://doclitservice.org/wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.mapping.j2wmapping.document.literal.wrapped.J2WDLSharedEndpoint"
)
public class J2WDLSharedEndpointImpl implements J2WDLSharedEndpoint {
    public String oneTwoThree(int one, long two, double three)  {
        return "" + one + ":" + two + ":" + three;
    }

    public String holderMethodDefault(javax.xml.ws.Holder<java.lang.String> varStringDefault) 
    {
	varStringDefault.value = "holderMethodDefault";
	return varStringDefault.value;
    }

    public String holderMethodInOut(javax.xml.ws.Holder<java.lang.String> varStringInOut) 
    {
	varStringInOut.value = "holderMethodInOut";
	return varStringInOut.value;
    }

    public String holderMethodOut(javax.xml.ws.Holder<java.lang.String> varStringOut) 
    {
	varStringOut.value = "holderMethodOut";
	return varStringOut.value;
    }

    public String helloWorld()  {
        return "hello world";
    }

    public String helloWorld(String hello)  {
        return hello;
    }

    public String stringOperation(String param)  {
        return param;
    }

    public String stringOperation2(String param)  {
        return param;
    }

    public String[] arrayOperation()  {
        return new String[] { "one", "two", "three" };
    }

    public J2WDLSharedBean getBean()  {
        return new J2WDLSharedBean(5, "A String");
    }

    public String arrayOperationFromClient(String[] array)  {
        return "success";
    }

    public void oneWayOperation()  {
    }

    public void operationWithHeaderAndHeaderFaultAndFault(ConfigHeader configheader) throws ConfigHeaderFault, MyFault {
    }

    public String hello(String hello)  {
	return hello;
    }

    public String bye(String bye)  {
	return bye;
    }

    public void methodWithNoReturn(int a, int b)  {
    }

    public void methodWithNoReturn2(String s)  {
    }

    public void operationThatThrowsAFault() throws MyOtherFault {
    }
}
