/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ServerLogicalHandler6.java 62638 2011-04-26 16:08:02Z adf $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.dlhandlerservice;

import com.sun.ts.lib.util.*;
import com.sun.ts.tests.jaxws.common.*;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.namespace.QName;
import javax.xml.soap.*;

public class ServerLogicalHandler6 extends LogicalHandlerBase
{

    private static final String WHICHHANDLERTYPE="Server";
    private static final String HANDLERNAME="ServerLogicalHandler6";

    private static final String NAMESPACEURI = "http://dlhandlerservice.org/wsdl";
    private final QName FAULTCODE = new QName(NAMESPACEURI, "ItsASoapFault", "tns");
    private static final String FAULTACTOR = "faultActor";
    private Name name = null;
    private javax.xml.soap.SOAPFault sf;


    public ServerLogicalHandler6(){
       super();
       super.setWhichHandlerType(WHICHHANDLERTYPE);
       super.setHandlerName(HANDLERNAME);
    }

    public boolean handleMessage(LogicalMessageContext context)
    {
      System.out.println("in "+this+":handleMessage");
      TestUtil.logTrace("in "+this+":handleMessage");
          Handler_Util.setTraceFlag(Handler_Util.getValueFromMsg(this, context, "harnesslogtraceflag"));

          Handler_Util.initTestUtil(this,
                                    Handler_Util.getValueFromMsg(this, context, "harnessloghost"),
                                    Handler_Util.getValueFromMsg(this, context, "harnesslogport"),
                                    Handler_Util.getValueFromMsg(this, context, "harnesslogtraceflag"));

         String direction = Handler_Util.getDirection(context);
         if (!Handler_Util.checkForMsg(this, context, "GetTrackerData")) {
             HandlerTracker.reportHandleMessage(this, Handler_Util.getDirection(context));
             if (direction.equals(Constants.INBOUND)){
                 if (Handler_Util.checkForMsg(this, context,"ServerLogicalInboundHandlerThrowsSOAPFaultToClientHandlersTest")) {
                      HandlerTracker.reportComment(this, "Throwing an inbound SOAPFaultException");
                      String faultString = "ServerLogicalHandler6.handleMessage throws SOAPFaultException for ServerLogicalInboundHandlerThrowsSOAPFaultToClientHandlersTest";
                      try {
                          name = SOAPFactory.newInstance().createName("somefaultentry");
                          sf = JAXWS_Util.createSOAPFault("soap11", FAULTCODE, FAULTACTOR, faultString, name);
                      } catch (Exception e) {
                          HandlerTracker.reportThrowable(this, new Exception("Unexpected error occurred in handleMessage for an inbound message"+e));
                      }
                      throw new SOAPFaultException(sf);
                 }
             } else {
                 if (Handler_Util.checkForMsg(this, context,"ServerLogicalOutboundHandlerThrowsSOAPFaultToClientHandlersTest")) {
                      HandlerTracker.reportComment(this, "Throwing an outbound SOAPFaultException");
                      String faultString = "ServerLogicalHandler6.handleMessage throws SOAPFaultException for ServerLogicalOutboundHandlerThrowsSOAPFaultToClientHandlersTest";
                      try {
                          name = SOAPFactory.newInstance().createName("somefaultentry");
                          sf = JAXWS_Util.createSOAPFault("soap11", FAULTCODE, FAULTACTOR, faultString, name);
                      } catch (Exception e) {
                          HandlerTracker.reportThrowable(this, new Exception("Unexpected error occurred in handleMessage for an inbound message"+e));
                      }
                      throw new SOAPFaultException(sf);
                 }

             }
         }
     System.out.println("exiting "+this+":handleMessage");
     TestUtil.logTrace("exiting "+this+":handleMessage");
     return true;
    }
}
