/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ProviderTestImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.wsa.w2j.document.literal.providertest;

import javax.xml.ws.*;
import java.io.ByteArrayInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;

import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.RespectBinding;

import com.sun.ts.tests.jaxws.common.JAXWS_Util;

@WebServiceProvider(
    serviceName="ProviderTestService",
    portName="ProviderTestPort",
    targetNamespace="http://providertestservice.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/ProviderTestService.wsdl"
)
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
@Addressing(enabled=true)
@MTOM(enabled=true)
@RespectBinding(enabled=true)
@ServiceMode (value=javax.xml.ws.Service.Mode.PAYLOAD)

public class ProviderTestImpl implements Provider<Source> {

    private static final javax.xml.bind.JAXBContext jaxbContext = createJAXBContext();

    public javax.xml.bind.JAXBContext getJAXBContext(){
        return jaxbContext;
    }

    private static javax.xml.bind.JAXBContext createJAXBContext(){
        try{
            return javax.xml.bind.JAXBContext.newInstance(com.sun.ts.tests.jaxws.wsa.w2j.document.literal.providertest.ObjectFactory.class);
        }catch(javax.xml.bind.JAXBException e){
            throw new WebServiceException(e.getMessage(), e);
        }
    }


    public Source invoke(Source req)  {
     System.out.println("**** Received in Provider Impl ******");
     DOMResult dr= null;
     try {
       dr= JAXWS_Util.getSourceAsDOMResult(req);
       System.out.println("->    Source="+JAXWS_Util.getDOMResultAsString(dr));

     }
     catch (Exception e) {
         System.out.println("Exception: failed getDOMResultAsString ... " + e);
     }
     try {
       HelloRequest request = recvBean(new DOMSource(dr.getNode()));
       String arg = request.getArgument();
       String response = "<HelloResponse xmlns=\"http://providertestservice.org/types\"><argument>"+arg+"</argument></HelloResponse>";
       System.out.println("Sending response="+response);
       Source source = new StreamSource(new ByteArrayInputStream(response.getBytes()));
       return source;
     }
     catch (Exception e) {
         e.printStackTrace();
         throw new WebServiceException("Provider endpoint failed", e);
     }
    }
    private HelloRequest recvBean(Source req) {
     System.out.println("*** recvBean ***");
     HelloRequest helloReq = null;
     try {
         helloReq = (HelloRequest) jaxbContext.createUnmarshaller().unmarshal(req);
         System.out.println("argument="+helloReq.getArgument());
     } catch (Exception e){
            System.out.println("Received an exception while parsing the source");
            e.printStackTrace();
     }
     return helloReq;
    }

}
