/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JDLR2709Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.R2709;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JDLR2709Client extends SOAPClient {

    public W2JDLR2709Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public W2JDLR2709Client(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jdlr2709testservice.org/W2JDLR2709TestService.wsdl");
        stubContext.setService("W2JDLR2709TestService");
        stubContext.setPort("W2JDLR2709TestPort");
        stubContext.setEndpointInterface(W2JDLR2709Test.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jdlr2709.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jdlr2709.wsdlloc.1";
    }

    public String echoString(String str) throws Exception {
        return ((W2JDLR2709Test)stubContext.getStub()).echoString(str);
    }
}
