/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R1016;

import com.sun.ts.lib.harness.*;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.wsi.requests.SOAPRequests;
import com.sun.javatest.Status;

import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPElement;
import javax.xml.ws.WebServiceException;
import java.util.Properties;
import java.util.Iterator;

public class Client extends ServiceEETest implements SOAPRequests{

    private W2JRLR1016Client client;

    
    static SimpleTest service = null;

    /**
     * Test entry point.
     *
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }


    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void setup(String[] args, Properties properties) throws EETest.Fault {
        client = (W2JRLR1016Client)ClientFactory.getClient(W2JRLR1016Client.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup(){
        logMsg("cleanup");
    }

    /**
     * @testName: testCanAcceptXMLLangAttribute
     *
     * @assertion_ids: WSI:SPEC:R1016
     *
     * @test_Strategy: Make a request that generates a fault with an
     * xml:lang attribute on the faultstring element, ensure the client can
     * accept the fault
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void testCanAcceptXMLLangAttribute() throws EETest.Fault {
        try{
            client.alwaysThrowsWebServiceException();
        }catch(WebServiceException e){
            // expected result
            TestUtil.logMsg("Received WebServiceException");
        } catch(Exception e){
            TestUtil.printStackTrace(e);
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
    }
}
