/*
 * Copyright (c) 2011, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72220 2013-06-24 17:42:24Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.application.navigationhandler;

import java.io.PrintWriter;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

public final class URLClient extends AbstractUrlClient {

	private static final String CONTEXT_ROOT = "/jsf_appl_navigationhandler_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out),
				new PrintWriter(System.err));
		s.exit();
	}

	public Status run(String args[], PrintWriter out, PrintWriter err) {
		setContextRoot(CONTEXT_ROOT);
		setServletName(DEFAULT_SERVLET_NAME);
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/* Test Declarations */

	/**
	 * @testName: navigationHandlerHandleNavigationCaseNPETest
	 * @assertion_ids: JSF:JAVADOC:255; JSF:JAVADOC:254
	 * @test_Strategy: Validate that we get a NullPointerException when
	 *                 FacesContext is null.
	 */
	public void navigationHandlerHandleNavigationCaseNPETest() throws Fault {
		TEST_PROPS.setProperty(APITEST,
				"navigationHandlerHandleNavigationCaseNPETest");
		invoke();
	}

} // end of URLClient
