/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TCKValidator.java 62525 2011-04-15 12:14:31Z dougd $
 */
 
package com.sun.ts.tests.jsf.api.javax_faces.component.common;

import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;

public class TCKValidator implements Validator{
    
    private static StringBuffer log = new StringBuffer();
    private String id;
    private boolean markInvalid;
    
    public TCKValidator() {
    }
    
    public TCKValidator(String id, boolean markInvalid) {
        this.id = id;
        this.markInvalid = markInvalid;
    }
    
    public void validate(FacesContext context, UIComponent component, Object value) {
        log.append("/" + id);
        if (markInvalid) {
            ((UIInput) component).setValid(false);
        } 
    }
    
    public void markInvalid(boolean markInvalid) {
        this.markInvalid = markInvalid;
    }
    
    public static String getTrace() {
        return log.toString();
    }
    
    public static void clearTrace() {
        log = new StringBuffer();                                
    }
}
