/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.html.htmlcommandbutton;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.html.HtmlCommandButton;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;


public final class TestServlet 
    extends com.sun.ts.tests.jsf.api.javax_faces.component.uicommand.TestServlet {

    private static final String[] attributes = {
        "accesskey", "alt", "dir", "image", "lang", "onblur", "onchange",
        "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress",
        "onkeyup", "onmousedown", "onmousemove", "onmouseout",
        "onmouseover", "onmouseup", "onselect", "style", "styleClass",
        "tabindex", "title", "type", "disabled", "readonly"
    };

    /**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws ServletException if an error occurs
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        setRendererType("javax.faces.Button");
        setAttributeNames(attributes);
    }


    /**
     * <p>Creates a new {@link UIComponent} instance.</p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    protected UIComponentBase createComponent() {
        return new HtmlCommandButton();
    }
    
// ------------------------------------------- Test Methods ----

}
