/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.component.uioutput;

import com.sun.ts.tests.jsf.api.javax_faces.component.common.BaseComponentTestServlet;

import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIOutput;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;


public class TestServlet extends BaseComponentTestServlet {

    /**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws ServletException if an error occurs
     */
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        setRendererType("javax.faces.Text");
    }

    /**
     * <p>Creates a new {@link UIComponent} instance.</p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    @Override
    protected UIComponentBase createComponent() {
        return new UIOutput();
    }
    // --------------------------------------------------------- Private Classes
    
    @ListenerFor(systemEventClass = PostAddToViewEvent.class,
    sourceClass = CustomOutput.class)
    @ResourceDependencies({
        @ResourceDependency(name = "#{'hello.js'}", library = "test",
        target = "#{'body'}"),
        @ResourceDependency(name = "black-n-blue.css", library = "#{'test'}")
    })
            
    public static final class CustomOutput
            extends UIOutput
            implements ComponentSystemEventListener {

        private boolean processEventInvoked;
        private ComponentSystemEvent event;

        @Override
        public void processEvent(ComponentSystemEvent event)
                throws AbortProcessingException {
            processEventInvoked = true;
            this.event = event;
        }

        public void reset() {
            processEventInvoked = false;
            event = null;
        }

        public boolean isProcessEventInvoked() {
            return processEventInvoked;
        }

        public ComponentSystemEvent getEvent() {
            return event;
        }
    }
}
